#include "imagedownloader.h"
#include <QNetworkReply>
#include <QImage>

ImageDownloader::ImageDownloader(QObject *parent) :
    QObject(parent),
    m_nam(new QNetworkAccessManager(this))
{
}

void ImageDownloader::downloadImages(Event event) {
    m_event = event;
    getNextImage();
}

void ImageDownloader::getNextImage() {
    if (!m_event.iconDownloaded()) {
        downloadImage(QUrl(m_event.iconPath()), SLOT(onIconDownloaded()));
    }
    else if (!m_event.imageOneDownloaded()) {
        downloadImage(QUrl(m_event.imagePathOne()), SLOT(onImageOneDownloaded()));
    }
    else if (!m_event.imageTwoDownloaded()) {
        downloadImage(QUrl(m_event.imagePathTwo()), SLOT(onImageTwoDownloaded()));
    }
    else {
        emit imagesDownloaded(m_event);
    }
}

void ImageDownloader::downloadImage(const QUrl &url, const char* slot) {
    QNetworkRequest request(url);
    QNetworkReply *reply = m_nam->get(request);
    connect(reply, SIGNAL(finished()), this, slot);
}

void ImageDownloader::onIconDownloaded() {
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(sender());

    if (!reply) {
        m_event.setIconPath("");
        return;
    }

    QString fileName(QString("/home/user/Event Feed/.images/%1-icon.%2").arg(m_event.eventId()).arg(m_event.iconFormat()));
    QImage image;

    if (image.loadFromData(reply->readAll())) {
        image = image.scaled(QSize(64, 64), Qt::IgnoreAspectRatio, Qt::SmoothTransformation);

        if ((!image.isNull()) && (image.save(fileName))) {
            m_event.setIconPath(fileName);
        }
        else {
            m_event.setIconPath("");
        }
    }
    else {
        m_event.setIconPath("");
    }

    getNextImage();

    reply->deleteLater();
}

void ImageDownloader::onImageOneDownloaded() {
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(sender());

    if (!reply) {
        m_event.setImagePathOne("");
        return;
    }

    QString fileName(QString("/home/user/Event Feed/.images/%1-image1.%2").arg(m_event.eventId()).arg(m_event.imageFormatOne()));
    QImage image;

    if (image.loadFromData(reply->readAll())) {
        image = image.scaled(QSize(150, 150), Qt::KeepAspectRatioByExpanding, Qt::SmoothTransformation);

        if ((!image.isNull()) && (image.save(fileName))) {
            m_event.setImagePathOne(fileName);
        }
        else {
            m_event.setImagePathOne("");
        }
    }
    else {
        m_event.setImagePathOne("");
    }

    getNextImage();

    reply->deleteLater();
}

void ImageDownloader::onImageTwoDownloaded() {
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(sender());

    if (!reply) {
        m_event.setImagePathTwo("");
        return;
    }

    QString fileName(QString("/home/user/Event Feed/.images/%1-image2.%2").arg(m_event.eventId()).arg(m_event.imageFormatTwo()));
    QImage image;

    if (image.loadFromData(reply->readAll())) {
        image = image.scaled(QSize(150, 150), Qt::KeepAspectRatioByExpanding, Qt::SmoothTransformation);

        if ((!image.isNull()) && (image.save(fileName))) {
            m_event.setImagePathTwo(fileName);
        }
        else {
            m_event.setImagePathTwo("");
        }
    }
    else {
        m_event.setImagePathTwo("");
    }

    getNextImage();

    reply->deleteLater();
}
