#include "abstractdialog.h"

AbstractDialog::AbstractDialog(QWidget *parent) :
    QDialog(parent),
    m_portrait(false)
{
    setAttribute(Qt::WA_DeleteOnClose, true);
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(onOrientationChanged()));
}

void AbstractDialog::onOrientationChanged() {
    QRect screen = QApplication::desktop()->screenGeometry();

    if (screen.width() > screen.height()) {
        m_portrait = false;
        setLandscapeLayout();
    }
    else {
        m_portrait = true;
        setPortraitLayout();
    }
}

void AbstractDialog::toggleBusy(bool busy) {
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, busy);
}
