#include "aboutdialog.h"
#include "utils.h"
#include <QDesktopServices>
#include <QUrl>
#include <QPixmap>

AboutDialog::AboutDialog(QWidget *parent) :
    AbstractDialog(parent),
    m_icon(new QLabel(this)),
    m_title(new QLabel("Hildon Event Feed " + Utils::versionNumberString(), this)),
    m_details(new QLabel(tr("An event feed application and widget for displaying events sent from third-party applications and scripts.") + "<br><br> &copy; Stuart Howarth 2012", this)),
    m_buttonBox(new QDialogButtonBox(Qt::Vertical, this)),
    m_donateButton(m_buttonBox->addButton(tr("Donate"), QDialogButtonBox::NoRole)),
    m_bugButton(m_buttonBox->addButton(tr("Report bug"), QDialogButtonBox::NoRole)),
    m_grid(new QGridLayout(this))
{
    setWindowTitle(tr("About"));
    m_icon->setPixmap(QPixmap(":/hildonevents.png"));
    m_icon->setFixedWidth(m_icon->pixmap()->width() + 10);
    QFont font;
    font.setBold(true);
    font.setPixelSize(32);
    m_title->setFont(font);
    m_details->setWordWrap(true);
    connect(m_donateButton, SIGNAL(clicked()), this, SLOT(donate()));
    connect(m_bugButton, SIGNAL(clicked()), this, SLOT(reportBug()));

    onOrientationChanged();
}

void AboutDialog::setLandscapeLayout() {
    setFixedHeight(220);
    m_buttonBox->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_icon, 0, 0);
        m_grid->addWidget(m_title, 0, 1);
        m_grid->addWidget(m_details, 1, 0, 1, 2, Qt::AlignBottom);
        m_grid->addWidget(m_buttonBox, 1, 2);
    }
    else {
        m_grid->setAlignment(m_details, Qt::AlignBottom);
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 1, 2);
    }
}

void AboutDialog::setPortraitLayout() {
    setFixedHeight(400);
    m_buttonBox->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_icon, 0, 0);
        m_grid->addWidget(m_title, 0, 1);
        m_grid->addWidget(m_details, 1, 0, 1, 2, Qt::AlignHCenter);
        m_grid->addWidget(m_buttonBox, 2, 0, 1, 2);
    }
    else {
        m_grid->setAlignment(m_details, Qt::AlignHCenter);
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 2, 0, 1, 2);
    }
}

void AboutDialog::donate() {
    QDesktopServices::openUrl(QUrl("https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=stuhowarth77@gmail.com&lc=GB&item_name=cuteTube&currency_code=USD&bn=PP%2dDonationsBF%3abtn_donate_SM%2egif%3aNonHosted"));
    close();
}

void AboutDialog::reportBug() {
    QDesktopServices::openUrl(QUrl("mailto:stuhowarth77@gmail.com?subject=Hildon Event Feed"));
    close();
}
