#ifndef ABSTRACTDIALOG_H
#define ABSTRACTDIALOG_H

#include <QDialog>
#include <QApplication>
#include <QDesktopWidget>

class AbstractDialog : public QDialog
{
    Q_OBJECT

public:
    explicit AbstractDialog(QWidget *parent = 0);
    inline bool inPortrait() const { return m_portrait; }

protected slots:
    void onOrientationChanged();

protected:
    inline virtual void setLandscapeLayout() {}
    inline virtual void setPortraitLayout() {}
    void toggleBusy(bool busy);

private:
    bool m_portrait;
};

#endif // ABSTRACTDIALOG_H
