
#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include <libhildondesktopmm/wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "plugin-item.h"
#include "home-plugin-item.h"
#include "status-plugin-item.h"
#include "status-menu-item.h"

extern "C"
{

//Declarations of the *_get_type() functions:

GType hd_home_plugin_item_get_type(void);
GType hd_status_menu_item_get_type(void);
GType hd_status_plugin_item_get_type(void);

//Declarations of the *_error_quark() functions:

} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

namespace HildonDesktop {  class HomePluginItem_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace HildonDesktop {  class StatusMenuItem_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace HildonDesktop {  class StatusPluginItem_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }

namespace HildonDesktop { 

void wrap_init()
{
  // Register Error domains:

// Map gtypes to gtkmm wrapper-creation functions:
  Glib::wrap_register(hd_home_plugin_item_get_type(), &HildonDesktop::HomePluginItem_Class::wrap_new);
  Glib::wrap_register(hd_status_menu_item_get_type(), &HildonDesktop::StatusMenuItem_Class::wrap_new);
  Glib::wrap_register(hd_status_plugin_item_get_type(), &HildonDesktop::StatusPluginItem_Class::wrap_new);

  // Register the gtkmm gtypes:
  HildonDesktop::HomePluginItem::get_type();
  HildonDesktop::StatusMenuItem::get_type();
  HildonDesktop::StatusPluginItem::get_type();

} // wrap_init()

} //HildonDesktop


