#include <gtk/gtk.h>
#include "systray-process.h"

static void
print_id(GdkNativeWindow wid, GtkWidget *wnd)
{
	gtk_widget_show(wnd);
	g_print("Embedding window with id %d\n", wid);
}

static void
dlg_response(GtkWidget *dlg, guint response_id, gpointer null)
{
	gtk_widget_hide(dlg);
}

static gboolean
delete_event(GtkWidget *widget, GdkEvent *event, gpointer null)
{
	return TRUE;
}

int
main(int argc, char **argv)
{
	GtkWidget *wnd, *event_box;

	gtk_init(&argc, &argv);

	wnd = g_object_new(GTK_TYPE_DIALOG, NULL);

	g_signal_connect(G_OBJECT(wnd), "response", (GCallback)dlg_response, NULL);
	g_signal_connect(G_OBJECT(wnd), "delete-event", (GCallback)delete_event, NULL);

	event_box = g_object_new(GTK_TYPE_EVENT_BOX, "visible", TRUE, NULL);

	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(wnd)->vbox), event_box, FALSE, TRUE, 0);

	gtk_widget_show(wnd);

	systray_setup(event_box, 8, 16, (WindowIDCallback)print_id, wnd);

	gtk_main();

	return 0;
}
