#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include "systray-status-menu-plugin.h"
#include "systray-process.h"

struct _SystrayStatusMenuPlugin {
	HDStatusMenuItem __parent_instance__;
};

struct _SystrayStatusMenuPluginClass {
	HDStatusMenuItem __parent_class__;
};

HD_DEFINE_PLUGIN_MODULE(SystrayStatusMenuPlugin, systray_status_menu_plugin, HD_TYPE_STATUS_MENU_ITEM);

static void
systray_status_menu_plugin_class_finalize(SystrayStatusMenuPluginClass *klass)
{
}

static void
systray_status_menu_plugin_class_init(SystrayStatusMenuPluginClass *klass)
{
}

static void
print_id(GdkNativeWindow wid, GtkWidget *wnd)
{
	gtk_widget_show(wnd);
	g_print("Embedding window with id %d\n", wid);
}

static void
dlg_response(GtkWidget *dlg, guint response_id, gpointer null)
{
	gtk_widget_hide(dlg);
}

static gboolean
delete_event(GtkWidget *widget, GdkEvent *event, gpointer null)
{
	return TRUE;
}

static void
systray_status_menu_plugin_init(SystrayStatusMenuPlugin *ssm_plugin)
{
	GtkWidget *wnd, *event_box, *btn;

	btn = g_object_new(GTK_TYPE_BUTTON, "visible", TRUE, "label", "System Tray", NULL);
	gtk_container_add(GTK_CONTAINER(ssm_plugin), btn);
/*
	wnd = g_object_new(GTK_TYPE_DIALOG, NULL);

	g_signal_connect(G_OBJECT(wnd), "response", (GCallback)dlg_response, NULL);
	g_signal_connect(G_OBJECT(wnd), "delete-event", (GCallback)delete_event, NULL);

	event_box = g_object_new(GTK_TYPE_EVENT_BOX, "visible", TRUE, NULL);

	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(wnd)->vbox), event_box, FALSE, TRUE, 0);

	gtk_widget_show(wnd);

	systray_setup(event_box, 8, 16, (WindowIDCallback)print_id, wnd);

	g_signal_connect_swapped(G_OBJECT(btn), "clicked", (GCallback)gtk_widget_show, wnd);
*/
}
