/*
 * Copyright (C) 2009-2010 Kimitake <kimitake@gmail.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
*/

#include <stdio.h>
#include <glib.h>
#include <glib/gprintf.h>
#include <string.h>
#include <time.h>
#include <sys/timeb.h>
#include <sys/stat.h>
#include <errno.h>

#include "log.h"

typedef enum {
	LOG_NOLOG = 0,
	LOG_ERROR,
	LOG_INFO,
	LOG_DEBUG,
} LOG_LEVEL;


const gchar tmp_dir[] = "/home/user/MyDocs/tmp/";
const gchar cfg_dir[] = "/home/user/.config/him-scim/";
const gchar cnf_file[] = "log.cfg";
const gchar log_file[] = "him-scim.log";

static gint log_level = LOG_NOLOG;
FILE *fp = NULL;

void log_init()
{
	if (fp)
		return;

	if (log_level == LOG_NOLOG)
		return;

	gchar filename[256]={0};
	gboolean bExistDir = TRUE;

#if 0
	fp = stderr;
#else
	if (mkdir(tmp_dir, 0777)<0) {
		if (errno != EEXIST) {
			perror("");
			bExistDir = FALSE;
			g_printf("cannot create %s directory\n", tmp_dir);
		}
	}
	if (bExistDir) {
		snprintf(filename, sizeof(filename)-1, "%s%s", tmp_dir, log_file);
		fp = fopen(filename, "a");
		if (!fp)
			g_printf("cannnot open %s\n", filename);
	}
#endif

	bExistDir = TRUE;
	if (mkdir(cfg_dir, 0755)<0) {
		if (errno != EEXIST) {
			bExistDir = FALSE;
			g_printf("cannot create %s directory\n", cfg_dir);
		}
	}
	if (bExistDir) {
		snprintf(filename, sizeof(filename)-1, "%s%s", cfg_dir, cnf_file);
		g_printf("filename:%s\n", filename);
		FILE *cfg = fopen(filename, "r");
		if (cfg) {
			gchar str[1024]={0};
			while (fgets(str, sizeof(str), cfg)!=NULL) {
				if (str[0]=='#')
					continue;

				sscanf(str, "loglevel=%d", &log_level);
			}
			g_printf("log level: %d\n", log_level);
			fclose(cfg);
		}
		else
			g_printf("cannnot open %s\n", filename);
	}

	logInfo("start logging\n");	
		
}

void log_end()
{
	if (!fp)
		return;

	fclose(fp);
	fp = NULL;
}

void logDate()
{
	if (!fp)
		return;

	struct timeb tstruct;
	time_t ltime;
	struct tm *t;

	tzset();

	ftime(&tstruct);
	time(&ltime);
	t = localtime(&ltime);
	fprintf(fp, "[%04d/%02d/%02d %02d:%02d:%02d.%03d] ",
			1900+t->tm_year, t->tm_mon+1, t->tm_mday,
			t->tm_hour, t->tm_min, t->tm_sec, tstruct.millitm);
}

void logError(const gchar *fmt, ...)
{
	if (log_level < LOG_ERROR)
		return;

	if (!fp)
		return;

	logDate();

	g_fprintf(fp, "[ERR] ");

	va_list ap;

	va_start(ap, fmt);
	g_vfprintf(fp, fmt, ap);
	va_end(ap);

	fflush(fp);
}

void logDebug(const gchar *fmt, ...)
{
	if (log_level < LOG_DEBUG)
		return;

	if (!fp)
		return;

	logDate();

	g_fprintf(fp, "[DBG] ");

	va_list ap;

	va_start(ap, fmt);
	g_vfprintf(fp, fmt, ap);
	va_end(ap);

	fflush(fp);
}

void logInfo(const gchar *fmt, ...)
{
	if (log_level < LOG_INFO)
		return;

	if (!fp)
		return;

	logDate();

	g_fprintf(fp, "[INF] ");

	va_list ap;

	va_start(ap, fmt);
	g_vfprintf(fp, fmt, ap);
	va_end(ap);

	fflush(fp);
}


