#!/bin/sh

# The goal of this script is to create/update/remove a custom user agent for MicroB
# This is needed on some operators network that filter PC traffic on public APN
#  based on the user agent (Maemo Browser is seen as Firefox 3.5)

UA_NEW_STRING=`cat /opt/HideUserAgent/UA.txt`;
UA_PARAM="general.useragent.override";
UA_SET="user_pref(\"$UA_PARAM\", \"$UA_NEW_STRING\");";
USER_JS=/home/user/.mozilla/microb/user.js
PREFS_JS=/home/user/.mozilla/microb/prefs.js

print_usage()
{
	echo "Incorrect supplied arguments";
	echo "USAGE: $0 set|remove|get";
	echo;
}

set_ua()
{
	if [ -w $USER_JS ]; then
		# File user.js already exists.
		# Check if there is already an active useragent string
		UA=`grep "^user_pref(\"$UA_PARAM" $USER_JS`;
		
		# If there is no active useragent string, check if it is commented
		#  otherwise add it at the end of the file.
		if [ -z "$UA" ]; then
			UA=`grep "^#user_pref(\"$UA_PARAM" $USER_JS | sed s/#//`;
			if [ "$UA" == "$UA_SET" ]; then
				UA_ESC=$(echo "$UA" | sed 's/\"/\\"/g');
				cat $USER_JS | sed s/^#"$UA_ESC"/"$UA_ESC"/ > $USER_JS.new;
				#mv $USER_JS $USER_JS.bkp.`date +%Y%m%d%H%M`;
				mv $USER_JS.new $USER_JS;
			else
				echo $UA_SET >> $USER_JS;
			fi;
		else
			# If the existing useragent is different, comment the line and add the new one.
			#  otherwise don't touch the file
			if [ "$UA" != "$UA_SET" ]; then
				UA_ESC=$(echo "$UA" | sed 's/\"/\\"/g');
				cat $USER_JS | sed /^"$UA_ESC"/d > $USER_JS.new;
				#mv $USER_JS $USER_JS.bkp.`date +%Y%m%d%H%M`;
				mv $USER_JS.new $USER_JS;
				echo $UA_SET >> $USER_JS;
			fi;
		fi;
	else
		# File user.js does not exist. Create it with the new useragent.
		echo $UA_SET > $USER_JS;
	fi;
	pkill -f browserui
}


remove_ua()
{
	# Remove from user.js file
	if [ -w $USER_JS ]; then
		UA=`grep "^user_pref(\"$UA_PARAM" $USER_JS`;
		
		# If there is a useragent string, remove the line
		if [ -n "$UA" ]; then
			UA_ESC=$(echo "$UA" | sed 's/\"/\\"/g');
			cat $USER_JS | sed /^"$UA_ESC"/d > $USER_JS.new;
			#mv $USER_JS $USER_JS.bkp.`date +%Y%m%d%H%M`;
			mv $USER_JS.new $USER_JS;
		fi;
	fi;
	
	# Remove from prefs.js
	UA=`grep "^user_pref(\"$UA_PARAM" $PREFS_JS`;
	
	# If there is a useragent string, remove the line
	if [ -n "$UA" ]; then
		UA_ESC=$(echo "$UA" | sed 's/\"/\\"/g');
		cat $PREFS_JS | sed /^"$UA_ESC"/d > $PREFS_JS.new;
		#mv $PREFS_JS $PREFS_JS.bkp.`date +%Y%m%d%H%M`;
		mv $PREFS_JS.new $PREFS_JS;
		pkill -f browserui;
	fi;
}

get_ua()
{
	if [ -w $USER_JS ]; then
		UA=`grep "^user_pref(\"$UA_PARAM" $USER_JS`;
		
		# If there is a useragent string, add a '#' in front of the line
		if [ -n "$UA" ]; then 
			echo "custom";
		else
			echo "default";
		fi;
	else
		echo "default";
	fi;
}

if [ $# -ne 1 ]; then
	print_usage;
	exit 1;
fi;

case "$1" in
"set")
	set_ua;
	exit 0;;
"remove")
	remove_ua;
	exit 0;;
"get")
	get_ua;
	exit 0;;
*)
	print_usage;
	exit 1;;
esac;
