/*******************************************************************************
 * Copyright (c) 2009 - Dart.
 *
 * This is an control panel applet done to enale or disable
 *  Maemo's web browser user agent.
 *
 */

/*
 ============================================================================
 Name        : main.c
 Author      : Dart
 Version     : 0.3
 Description : Control Panel Applet to customize MicroB useragent.
 ============================================================================
 */


#ifndef _
#define _(String) gettext(String)
#endif

#ifndef N_
#define N_(String) (String)
#endif

#include <libintl.h>
#include <locale.h>
#include <glib/gi18n.h>
#include <hildon-cp-plugin/hildon-cp-plugin-interface.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <hildon/hildon.h>


#define RESPONSE_SET 100
#define RESPONSE_REMOVE 200
#define RESPONSE_UA 300

void displayresult (GtkWidget *parent, const char *Text)
{
  GtkWidget *banner;

  banner = hildon_note_new_information(GTK_WINDOW(parent), Text);
  gint retcode = gtk_dialog_run (GTK_DIALOG (banner));
  gtk_widget_destroy (banner);
  return;
}

void write_ua ( const char * ua )
{
	if (strlen(ua)>0) {
		FILE *file = fopen ( _("/opt/HideUserAgent/UA.txt"), _("w") );

		if ( file != NULL )
		{
			fputs(ua, file);
			fclose ( file );
		}
	}
}

char * read_ua ( void )
{
	gchar *ua;
	FILE *file = fopen ( _("/opt/HideUserAgent/UA.txt"), _("r") );

	if ( file != NULL )
	{
		char line [ 256 ];

		if ( fgets ( line, sizeof line, file ) != NULL )
		{
			ua = g_strdup(line);
		}
		fclose ( file );
	}
	return ua;
}

/* This displays a dialog box allowing the user to specify the useragent */
void AskForUserAgent(GtkWidget *parent)
{
	GtkWidget *dialog, *Caption, *UaString;
	gint response;
	gchar *ua;

	dialog = gtk_dialog_new_with_buttons(
			_("Specify the User Agent to use"),
			GTK_WINDOW(parent),
			GTK_DIALOG_MODAL | GTK_DIALOG_NO_SEPARATOR,
			GTK_STOCK_OK,
			GTK_RESPONSE_OK,
			GTK_STOCK_CANCEL,
			GTK_RESPONSE_CANCEL,
			NULL);

	UaString = hildon_entry_new (HILDON_SIZE_AUTO);
	ua=read_ua();
	gtk_entry_set_text(UaString, ua);

	Caption = hildon_caption_new (NULL, _("User Agent"), UaString, NULL, HILDON_CAPTION_MANDATORY);
	gtk_container_add (GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), Caption);
	gtk_widget_show_all (dialog);


	/* Wait until user finishes the dialog. */
	response = gtk_dialog_run(GTK_DIALOG(dialog));
	if (response == GTK_RESPONSE_OK)
	{
		write_ua(gtk_entry_get_text (UaString));
	}
	/* Free the dialog (and it's children) */
	gtk_widget_destroy(GTK_WIDGET(dialog));
	/*g_free(ua);*/
}

osso_return_t execute(osso_context_t *osso, gpointer data, gboolean user_activated)
{
	GtkWidget *dialog;
	char line[10];
	gint response, res;
	GtkWidget *LabelStatus, *LabelText;

	setlocale(LC_ALL, "");
	bindtextdomain(_("hideuseragent"), _("/usr/share/locale"));
	bind_textdomain_codeset(_("hideuseragent"), _("UTF-8"));
	textdomain(_("hideuseragent"));

	FILE* result = popen(_("/opt/HideUserAgent/MicroBUserAgent.sh get"), _("r"));
	if (fgets(line, 8, result)==NULL) {
		printf (_("ERROR fgets\n"));
	}
	pclose(result);

	LabelStatus = gtk_label_new("");
	if (!g_strcmp0(line, _("default"))) {
		gtk_label_set_markup(GTK_LABEL(LabelStatus), _("<span color=\"red\">The user agent is not currently customized.</span>"));
	} else {
		gtk_label_set_markup(GTK_LABEL(LabelStatus), _("<span color=\"red\">The user agent is currently customized.</span>"));
	}

	/* Create dialog with OK and Cancel buttons. Leave the separator out,
	 * as we do not have any content. */
	dialog = gtk_dialog_new_with_buttons(
		_("Hide User Agent"),
		GTK_WINDOW(data),
		GTK_DIALOG_MODAL | GTK_DIALOG_NO_SEPARATOR,
		_("Set"),
		RESPONSE_SET,
		_("Remove"),
		RESPONSE_REMOVE,
		_("User Agent"),
		RESPONSE_UA,
		NULL);

	LabelText = gtk_label_new(_("Please choose whether you want to set or remove the customization of Maemo Browser's user agent."));
	gtk_label_set_justify(GTK_LABEL(LabelText), GTK_JUSTIFY_LEFT);
	gtk_label_set_line_wrap(GTK_LABEL(LabelText), TRUE);
    gtk_container_add (GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), LabelText);
    gtk_container_add (GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), LabelStatus);


	gtk_widget_show_all (dialog);

	response=-1;
	/* Wait until user finishes the dialog. */
	while (response==-1) {
		response = gtk_dialog_run(GTK_DIALOG(dialog));

		if (response == RESPONSE_SET) {
			/* This correspond to the set command */
			res=system(_("/opt/HideUserAgent/MicroBUserAgent.sh set"));
			if (!res) {
				displayresult(dialog, _("User agent successfully updated. Browser will be restarted."));
			} else {
				displayresult(dialog, _("Error during user agent update"));
			}
		}
		else if (response == RESPONSE_REMOVE) {
			/* This is a remove command */
			res=system(_("/opt/HideUserAgent/MicroBUserAgent.sh remove"));
			if (!res) {
				displayresult(dialog, _("User agent successfully updated. Browser will be restarted."));
			} else {
				displayresult(dialog, _("Error during user agent update"));
			}
		}
		else if (response == RESPONSE_UA) {
			/* This is the command to specify a useragent */
			AskForUserAgent(dialog);
			response = -1;
		}
	}
	/* Free the dialog (and it's children) */
	gtk_widget_destroy(GTK_WIDGET(dialog));
	return OSSO_OK;
}

osso_return_t save_state(osso_context_t *osso, gpointer data)
{
	return OSSO_OK;
}
