from org.maemo.hermes.engine.phonenumber import PhoneNumber
import unittest

class TestPhoneNumber(unittest.TestCase):
    
    def test_that_simple_number_is_returned(self):
        num = PhoneNumber('01234 567890')
        assert num.get_number() == '01234567890'
        
        
    def test_other_properties(self):
        num = PhoneNumber('01234 567890', type='home', device='landline', country = 'xx')
        assert num.get_number() == '01234567890'
        assert num.get_type() == 'home'
        assert num.get_device() == 'landline'
        assert num.get_country() == 'xx'
        
    def test_already_countrified(self):
        num = PhoneNumber('+441234 567890')
        assert num.get_number() == '+441234567890'

        num = PhoneNumber('+441234 567890', country = 'fr')
        assert num.get_number() == '+441234567890'
        
        
    def test_country_code_formatting(self):
        num = PhoneNumber('555-1234', country = 'us')
        assert num.get_number() == '+15551234'
        

    def test_special_country_code_formatting(self):
        num = PhoneNumber('(0)3 20 73 88 87', country = 'fr')
        assert num.get_number() == '+33320738887'

        num = PhoneNumber('01234 567890', country = 'gb')
        assert num.get_number() == '+441234567890'

    
if __name__ == '__main__':
    unittest.main()
