import urllib, urllib2
import simplejson

class FacebookApi():
    """Facebook backend for Hermes, using the Graph API:
    
          http://developers.facebook.com/docs/reference/api/
       
       Copyright (c) Andrew Flegg <andrew@bleb.org> 2010.
       Released under the Artistic Licence."""
       
       
    # -----------------------------------------------------------------------
    def __init__(self, oauth):
        self._oauth = oauth


    # -----------------------------------------------------------------------
    def authenticate(self):
        '''Authenticate the user with Facebook.'''
        
        self._oauth.authorise('https://graph.facebook.com/oauth/authorize',
                              'https://graph.facebook.com/oauth/access_token',
                              {'scope': 'user_about_me,friends_about_me,user_birthday,friends_birthday,user_website,friends_website,user_work_history,friends_work_history'})


    # -----------------------------------------------------------------------
    def get_user(self):
        '''Return the name of the authenticated user.'''
        
        data = self._request('https://graph.facebook.com/me')
        return data['name']


    # -----------------------------------------------------------------------
    def get_friends(self):
        '''Return the full list of people being followed by the user.
        
           The result is a list of users:
           http://developers.facebook.com/docs/reference/api/user/'''

        def copy(data, from_key, to, to_key = None):
            if not to_key:
                to_key = from_key
                
            if from_key in data:
                to[to_key] = data[from_key]

        users = self._request('https://graph.facebook.com/me/friends', {'fields': 'id,name,link,birthday,website,picture', 'type': 'large'})
        return users['data']
    
    
    # -----------------------------------------------------------------------
    def _request(self, url, args = None):
        """Make an authenticated request to Facebook and check the
           JSON response. Return the dictionary if no errors."""
        
        json = self._oauth.request(url, args)
#        print json
        data = simplejson.loads(json)
        if 'error' in data:
            raise Exception(data['error'])
        
        return data
