import trans
import re

"""Utilities for determing name variants.

   Copyright (c) Andrew Flegg <andrew@bleb.org> 2009.
   Released under the Artistic Licence."""

__non_alpha__ = re.compile("[^A-Za-z]+")

__names__ = [
    ['andrew', 'andy', 'andi', 'drew'],
    ['benjamin', 'ben', 'benny'],
    ['christian', 'chris'],
    ['christopher', 'chris'],
    ['david', 'dave'],
    ['daniel', 'dan', 'danny'],
    ['joseph', 'joey', 'joe'],
    ['joanna', 'jo'],
    ['joanne', 'jo'],
    ['matthew', 'matt', 'mat', 'matty'],
    ['melanie', 'mel'],
    ['michael', 'mike', 'mic', 'mik', 'micky'],
    ['peter', 'pete'],
    ['robert', 'rob', 'bob', 'bobby', 'robbie'],
    ['thomas', 'tom', 'tommy']
  ]

__map__ = {}
for row in __names__:
    for name in row:
        if (not name in __map__):
            __map__[name] = set(row)
        else:
            __map__[name] = __map__[name].union(row)


# -----------------------------------------------------------------------
def canonical(name, strip = True):
    """Return a transliterated, lower-case version of name; optionally
       stripping all non-alphabetic characters from the result."""
    
    try:
        result = unicode(name).encode('trans').lower()
        if strip:
            return __non_alpha__.sub('', result)
        else:
            return result
    except UnicodeDecodeError:
        result = name.lower()
        if strip:
            return __non_alpha__.sub('', result)
        else:
            return result

# -----------------------------------------------------------------------
def variants(name):
    """Return a set of names which should be checked for given the input
       name. Any word which is has a replacement will be replaced, and an
       iterable list of all variants will be returned."""

    result = set()
    if (name is None):
        return result
    
    name = canonical(name, strip = False)
    result.add(name)
    bits = name.split(' ')
    for bit in bits:
        if (bit in __map__):
            for replacement in __map__[bit]:
                result.add(name.replace(bit, replacement))

    return result

