from org.maemo.hermes.engine.gravatar.service import Service
from org.maemo.hermes.engine.friend import Friend 
import unittest

class FakeContact():
    def __init__(self, addr):
        self.urls = addr
    def get_emails(self):
        return self.urls
    def get_name(self):
        return self.urls[0]
    
class IntegrationTestGravatarService(unittest.TestCase):
    
    def setUp(self):
        self.testee = Service('gravatar', 'maemohermes@wendt.se', 'b14ec179822b')
        
        self.existing_address = 'fredrik@wendt.se'
        self.existing_contact = FakeContact([self.existing_address])
        self.existing_friend = Friend("Fredrik Wendt")
        
        self.missing_address = 'will_not_ever_exist_i_truly_hope_at_least@wendt.se'
        self.missing_contact = FakeContact([self.missing_address])
        self.missing_friend = Friend("Unknown Person")
        
        self.multiple_contact = FakeContact([self.existing_address, self.missing_address])
        self.multiple_friend = Friend("Another Person")
        
        
    def test_main_flow(self):
        self.testee.pre_process_contact(self.existing_contact)
        self.testee.pre_process_contact(self.missing_contact)
        self.testee.process_friends()
        existing_friend = self.testee.process_contact(self.existing_contact)
        missing_friend = self.testee.process_contact(self.missing_contact)
        
        assert isinstance(existing_friend, Friend)
        assert missing_friend is None
        
        friends = self.testee._get_friends()
        contacts = self.testee._get_contacts_with_match()
        assert len(friends) == 1
        assert len(contacts) == 1
        assert self.missing_contact not in contacts.keys()
        assert self.existing_contact in contacts.keys()
        friend = friends[0]
        assert friend.get_name() == self.existing_contact.get_name()


    
if __name__ == '__main__':
    unittest.main()
