from org.maemo.hermes.engine.linkedin.service import Service
from org.maemo.hermes.engine.linkedin.api import LinkedInApi
from org.maemo.hermes.engine.names import canonical
from org.maemo.hermes.engine.friend import Friend
import unittest, sys
import httplib

def log(msg):
    sys.__stderr__.write(msg + "\n")

class FakeGConf(dict):
    def __init__(self, props=None):
        dict.__init__(self)
        if props:
            for key in props:
                self.set_string(key, props[key])
    def get_string(self, key):
        try: return self.__getitem__(key)
        except: return None
    def set_string(self, key, value):
        log("gconf %s = %s" % (key, value))
        self.__setitem__(key, value)

class TestLinkedInApi(unittest.TestCase):
    
    def setUp(self):
        self.gconf = FakeGConf({
                LinkedInApi.GCONF_API_KEY:'1et4G-VtmtqNfY7gF8PHtxMOf0KNWl9ericlTEtdKJeoA4ubk4wEQwf8lSL8AnYE',
                LinkedInApi.GCONF_API_SECRET:'uk--OtmWcxER-Yh6Py5p0VeLPNlDJSMaXj1xfHILoFzrK7fM9eepNo5RbwGdkRo_',
                LinkedInApi.GCONF_ACCESS_TOKEN:None })
        self.testee = LinkedInApi(self.gconf)

        # uncomment to increase verbosity on HTTP level
        #httplib.HTTPSConnection.debuglevel = 1
        #httplib.HTTPConnection.debuglevel = 1

        
    def test_typical_flow(self):
        # uncomment next line if you need to authorize ...
        #self.testee.authenticate(self._need_auth_cb, self._block_for_auth)
        # ... or uncomment the following four lines - replacing the oauth_token string with whatever you got
        self.gconf.set_string(
                  LinkedInApi.GCONF_ACCESS_TOKEN, 
                  'oauth_token=f89c2b7b-1c12-4f83-a469-838e78901716&oauth_token_secret=60f817af-6437-4015-962f-cc3aefee0264')
        self.testee = LinkedInApi(self.gconf)
        
        # uncomment to see the raw xml feed for all connections
        #xml = self.testee._make_api_request(LinkedInApi.LI_CONN_API_URL)
        #open("/tmp/linkdata", "w").write(xml)
        
        # uncomment to see the raw xml feed for a connection (maemohermes)
        #xml = self.testee.get_friend_details('http://api.linkedin.com/v1/people/V8pEL-382L:full', 'name:eaU4')
        #open("/tmp/linkdata2", "w").write(xml)
        
        # uncomment if you want to inspect the friend objects returned
        friends = self.testee.get_friends()
        for f in friends:
            photo = f.get_photo_url()
            if photo: print photo
        

    def _need_auth_cb(self):
        self.need_auth_called = True


    def _block_for_auth(self, verifier, url=None):
        import os, time
        file = "/tmp/verifier"
        verifier = None
        msg = "Now open a browser to " + url + " and put the verification code into " + file + " like 'echo 01234 > " + file + "'"
        log(msg)
        while True:
            if os.path.exists(file):
                verifier = open(file).read().strip()
                os.remove(file)
                break
            time.sleep(2)
        log("verifier: <" + verifier + ">")
        return verifier

    
if __name__ == '__main__':
    unittest.main()
