import trans

"""Utilities for determing name variants.

   Copyright (c) Andrew Flegg <andrew@bleb.org> 2009.
   Released under the Artistic Licence."""

__names__ = [
    ['Andrew', 'Andy', 'Andi', 'Drew'],
    ['Christian', 'Chris'],
    ['Christopher', 'Chris'],
    ['David', 'Dave'],
    ['Daniel', 'Dan', 'Danny'],
    ['Michael', 'Mike', 'Mic', 'Mik', 'Micky'],
    ['Peter', 'Pete'],
    ['Robert', 'Rob', 'Bob', 'Bobby', 'Robbie'],
  ]

__map__ = {}
for row in __names__:
  for name in row:
    if (not name in __map__):
      __map__[name] = set(row)
    else:
      __map__[name] = __map__[name].union(row)

# -----------------------------------------------------------------------
def variants(name):
    """Return a set of names which should be checked for given the input
       name. Any word which is has a replacement will be replaced, and an
       iterable list of all variants will be returned."""

    result = set()
    if (name is None):
      return result
    
    name = unicode(name).encode('trans')
    result.add(name)
    bits = name.split(' ')
    for bit in bits:
      if (bit in __map__):
        for replacement in __map__[bit]:
          result.add(name.replace(bit, replacement))

    return result

