#!/usr/bin/env python

import gtk, gobject
import gnome.gconf
import hildon, osso
import traceback
import time
import thread
import contactview
import urllib2	
from hermes import Hermes

gobject.threads_init()

class HermesGUI:
  """Provides the GUI for Hermes, allowing the syncing of Facebook and
     Twitter friends' information with the Evolution contacts' database.
       
     Copyright (c) Andrew Flegg <andrew@bleb.org> 2009.
     Released under the Artistic Licence."""


  # -----------------------------------------------------------------------
  def __init__(self):
    """Constructor. Initialises the gconf connection."""
    self.gc = gnome.gconf.client_get_default()


  # -----------------------------------------------------------------------
  def doSync(self, widget, force, main = True):
    if main and not self.get_use_facebook() and not self.get_use_twitter():
      saved = self.open_prefs()
      if saved == gtk.RESPONSE_DELETE_EVENT:
        return

    if main:
      self.window.set_property('sensitive', False)
      thread.start_new_thread(self.doSync, (widget, force, False))
    else:
      try:
        fb2c = Hermes(self,
                      twitter = (self.get_use_twitter() and self.get_twitter_credentials()) or None,
                      facebook = self.get_use_facebook(),
                      empty = self.get_create_empty())
        fb2c.load_friends()
        fb2c.sync_contacts(resync = force)
        gobject.idle_add(self.open_summary, fb2c)

      except urllib2.HTTPError, e:
        traceback.print_exc()
        if e.code == 401:
          gobject.idle_add(self.report_error, 'Authentication problem. Check credentials.', True)
        else:
          gobject.idle_add(self.report_error, 'Network connection error. Check connectivity.')

      except urllib2.URLError, e:
        traceback.print_exc()
        gobject.idle_add(self.report_error, 'Network connection error. Check connectivity.')
      
      except Exception, e:
        traceback.print_exc()
        gobject.idle_add(self.report_error, 'Something went wrong: ' + e.message)


  # -----------------------------------------------------------------------
  def open_summary(self, fb2c):
    gobject.idle_add(self.window.set_property, 'sensitive', True)

    dialog = gtk.Dialog('Summary', self.window)
    dialog.add_button('Done', gtk.RESPONSE_OK)
    
    button = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL,
                           title = 'Updated %d contacts' % (len(fb2c.updated)))
    button.connect('clicked', self.show_contacts, fb2c.updated)
    button.set_property('sensitive', len(fb2c.updated) > 0)
    dialog.vbox.add(button)
    
    button = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL,
                           title = 'Matched %d contacts' % (len(fb2c.matched)))
    button.connect('clicked', self.show_contacts, fb2c.matched)
    button.set_property('sensitive', len(fb2c.matched) > 0)
    dialog.vbox.add(button)
    
    button = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL,
                           title = '%d contacts unmatched' % (len(fb2c.unmatched)))
    button.connect('clicked', self.show_contacts, fb2c.unmatched)
    button.set_property('sensitive', len(fb2c.unmatched) > 0)
    dialog.vbox.add(button)
    
    dialog.show_all()
    dialog.run()
    dialog.hide()
  

  # -----------------------------------------------------------------------
  def show_contacts(self, widget, contacts):
    view = contactview.ContactView(contacts)

    dialog = gtk.Dialog('Contacts', self.window)
    #view.connect('contact-activated', self.map_contact)
    dialog.vbox.add(view)
    dialog.show_all()
    
    dialog.run()
    dialog.hide()
    
    
  # -----------------------------------------------------------------------
  def map_contact(self, widget, contact):
    print widget, contact


  # -----------------------------------------------------------------------
  def open_prefs(self, widget = None):
    dialog = gtk.Dialog('Accounts', self.window)
    dialog.add_button('Save', gtk.RESPONSE_OK)

    #pa = hildon.PannableArea()
    #dialog.vbox.add(pa)
    content = dialog.vbox 
    #content = gtk.VBox()
    #pa.add(content)
    #pa.set_size_request(600, 380)

    use_facebook = self.new_checkbox('Use Facebook', content)
    use_facebook.set_active(self.get_use_facebook())

    indent = self.new_indent(content)
    fb_msg = self.add_linked(indent, use_facebook, gtk.Label('Note: authentication via web page'))
    fb_msg.set_property('justify', gtk.JUSTIFY_LEFT)
    
    fb_empty = self.add_linked(indent, use_facebook, self.new_checkbox('Create birthday-only contacts'))
    fb_empty.set_active(self.get_create_empty())

    use_twitter = self.new_checkbox('Use Twitter', content)
    use_twitter.set_active(self.get_use_twitter())

    indent = self.new_indent(content)
    tw_user = self.add_linked(indent, use_twitter, self.new_input('Twitter username'))
    tw_user.set_text(self.get_twitter_credentials()[0])

    tw_pass = self.add_linked(indent, use_twitter, self.new_input('Twitter password'))
    tw_pass.set_property('hildon-input-mode', gtk.HILDON_GTK_INPUT_MODE_FULL |
                                              gtk.HILDON_GTK_INPUT_MODE_INVISIBLE)
    tw_pass.set_text(self.get_twitter_credentials()[1])

    dialog.show_all()
    result = dialog.run()
    dialog.hide()
    if result == gtk.RESPONSE_OK:
      self.set_use_facebook(use_facebook.get_active())
      self.set_create_empty(fb_empty.get_active())
      self.set_use_twitter(use_twitter.get_active(), tw_user.get_text(), tw_pass.get_text())

    return result
 
  # -----------------------------------------------------------------------
  def new_checkbox(self, label, box = None):
    checkbox = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
    checkbox.set_label(label)
    if box:
      box.add(checkbox)
    return checkbox


  # -----------------------------------------------------------------------
  def new_indent(self, box):
    outer = gtk.HBox()
    indent = gtk.VBox()
    outer.pack_start(indent, padding=48)
    box.add(outer)
    return indent

 
  # -----------------------------------------------------------------------
  def new_input(self, text, box = None):
    input = hildon.Entry(gtk.HILDON_SIZE_FINGER_HEIGHT)
    input.set_property('hildon-input-mode', gtk.HILDON_GTK_INPUT_MODE_FULL)
    input.set_placeholder(text)
    input.set_property('is-focus', False)
    if box:
      box.add(input)
    return input


  # -----------------------------------------------------------------------
  def add_linked(self, box, ctrl, to_add):
    box.add(to_add)
    self.sync_edit(ctrl, to_add)
    ctrl.connect('toggled', self.sync_edit, to_add)
    return to_add
  
    
  # -----------------------------------------------------------------------
  def sync_edit(self, use_twitter, edit):
    edit.set_property('sensitive', use_twitter.get_active())


  # -----------------------------------------------------------------------
  def need_auth(self, main = False):
    if main:
      hildon.hildon_banner_show_information(self.window, '', "Need to authenticate with Facebook")
    else:
      gobject.idle_add(self.need_auth, True)
    

  # -----------------------------------------------------------------------
  def block_for_auth(self, main = False, lock = None):
    if main:
      note = gtk.Dialog('Facebook authorisation', self.window)
      note.add_button("Validate", gtk.RESPONSE_OK)
      note.vbox.add(gtk.Label("\nPress 'Validate' once Facebook has\nbeen authenticated in web browser.\n"))

      note.show_all()
      result = note.run()
      note.hide()
      lock.release()
      
    else:
      time.sleep(2)
      lock = thread.allocate_lock()
      lock.acquire()
      gobject.idle_add(self.block_for_auth, True, lock)
      lock.acquire()
      lock.release()


  # -----------------------------------------------------------------------
  def progress(self, i, j, main = False):
    if main:
      if i == 0:
        self.progressbar = gtk.ProgressBar()
        self.progressnote = gtk.Dialog("Fetching friends' info", self.window)
        self.progressnote.vbox.add(self.progressbar)
        hildon.hildon_gtk_window_set_progress_indicator(self.progressnote, 1)
        
        self.progressnote.show_all()
        
      elif i < j:
        if i == 1:
          self.progressnote.set_title("Updating contacts")
          hildon.hildon_gtk_window_set_progress_indicator(self.progressnote, 0)
          
        self.progressbar.set_fraction(float(i) / float(j))
        
      else:
        self.progressnote.destroy()
        
      print i,j
    else:
      gobject.idle_add(self.progress, i, j, True)


  # -----------------------------------------------------------------------
  def report_error(self, e, prefs = False):
    if self.progressnote:
      self.window.set_property('sensitive', True)
      self.progressnote.destroy()

    hildon.hildon_banner_show_information(self.window, '', e)
    if prefs:
      self.open_prefs()


  # -----------------------------------------------------------------------
  def main(self):
    # -- Window and app...
    #
    self.app = hildon.Program()
    self.window = hildon.Window()
    gtk.set_application_name('Hermes')
    self.osso_context = osso.Context('org.maemo.hermes', '0.0.5', False)
    self.app.add_window(self.window)

    self.window.connect("delete-event", gtk.main_quit)

    # -- Main window buttons...
    #
    box = gtk.HButtonBox()
    self.window.add(box)
    
    box.set_property('layout-style', gtk.BUTTONBOX_SPREAD)
    button = hildon.Button(gtk.HILDON_SIZE_THUMB_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL,
                           title = 'Retrieve', value = "Get contacts' missing info")
    button.set_property('width-request', 250)
    button.connect('clicked', self.doSync, False)
    box.add(button)

    button = hildon.Button(gtk.HILDON_SIZE_THUMB_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL,
                           title = 'Update', value = "Update contacts' info")
    button.set_property('width-request', 250)
    button.connect('clicked', self.doSync, True)
    box.add(button)
    
    # -- Application menu...
    #
    menu = hildon.AppMenu()
    button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
    button.set_label("Accounts")
    button.connect("clicked", self.open_prefs)
    menu.append(button)
    menu.show_all()
    self.window.set_app_menu(menu)
  
    self.window.show_all()
    gtk.main()


  def get_use_facebook(self):
    return self.gc.get_bool("/apps/maemo/hermes/use_facebook")


  def set_use_facebook(self, value):
    self.gc.set_bool("/apps/maemo/hermes/use_facebook", value)

  def get_create_empty(self):
    return self.gc.get_bool("/apps/maemo/hermes/create_empty")


  def set_create_empty(self, value):
    self.gc.set_bool("/apps/maemo/hermes/create_empty", value)


  def get_use_twitter(self):
    return self.gc.get_bool("/apps/maemo/hermes/use_twitter")


  def set_use_twitter(self, value, user, password):
    self.gc.set_bool("/apps/maemo/hermes/use_twitter", value)
    self.gc.set_string("/apps/maemo/hermes/twitter_user", user)
    self.gc.set_string("/apps/maemo/hermes/twitter_pwd", password)
    
  
  def get_twitter_credentials(self):
    return (self.gc.get_string("/apps/maemo/hermes/twitter_user") or '',
            self.gc.get_string("/apps/maemo/hermes/twitter_pwd") or '')


# -------------------------------------------------------------------------
if __name__ == '__main__':
  HermesGUI().main()

