TARGET = heliumreborn

TEMPLATE = app

QT += declarative \
    gui \
    core \
    network \
    webkit \
    opengl \
    sql

# Additional import path used to resolve QML modules in Creator's code model
QML_IMPORT_PATH =

symbian:TARGET.UID3 = 0xE244D944

# Smart Installer package's UID
# This UID is from the protected range and therefore the package will
# fail to install if self-signed. By default qmake uses the unprotected
# range value if unprotected UID is defined for the application and
# 0x2002CCCF value if protected UID is given to the application
#symbian:DEPLOYMENT.installer_header = 0x2002CCCF

# Allow network access on Symbian
symbian:TARGET.CAPABILITY += NetworkServices

# If your application uses the Qt Mobility libraries, uncomment the following
# lines and add the respective components to the MOBILITY variable.
# CONFIG += mobility
# MOBILITY +=

# Speed up launching on MeeGo/Harmattan when using applauncherd daemon
CONFIG += qdeclarative-boostable

# Add dependency to Symbian components
# CONFIG += qt-components

# The .cpp file which was generated for your project. Feel free to hack it.
SOURCES += main.cpp \
    Core.cpp \
    MainView.cpp \
    Logbook.cpp \
    FaviconImageProvider.cpp \
    CoreDbHelper.cpp \
    models/LinkItemsSharedCaches.cpp \
    models/HistoryListModel.cpp \
    models/BookmarksListModel.cpp \
    WebViewInterface.cpp \
    Settings.cpp \
    models/MostVisitedListModel.cpp \
    utility/SqliteDbHelper.cpp

# Please do not modify the following two lines. Required for deployment.
include(qmlapplicationviewer/qmlapplicationviewer.pri)
qtcAddDeployment()

target.path=/usr/bin

RESOURCES += \
    res.qrc

HEADERS += \
    Core.h \
    MainView.h \
    LogbookLinkItems.h \
    Logbook.h \
    LinkItem.h \
    FaviconImageProvider.h \
    CoreDbHelper.h \
    models/LinkItemsSharedCaches.h \
    models/HistoryListModel.h \
    models/BookmarksListModel.h \
    WebViewInterface.h \
    Settings.h \
    models/MostVisitedListModel.h \
    utility/SqliteDbHelper.h \
    utility/macros.h \
    utility/Declarativable.h \
    buildconfig.h

INCLUDEPATH+= utility

OTHER_FILES += \
    qml/HeliumReborn/MainPage.qml \
    qml/HeliumReborn/main.qml \
    qml/HeliumReborn/LogbookView.qml \
    qml/HeliumReborn/Header.qml \
    qml/HeliumReborn/FlickableWebView.qml \
    qml/HeliumReborn/FieldText.qml \
    qml/HeliumReborn/common/VScrollDropShadow.qml \
    qml/HeliumReborn/common/VHScrollDropShadow.qml \
    qml/HeliumReborn/common/TopDropShadow.qml \
    qml/HeliumReborn/common/ToolTip.qml \
    qml/HeliumReborn/common/TemporaryMessageWithIcon.qml \
    qml/HeliumReborn/common/ScrollBar.qml \
    qml/HeliumReborn/common/HScrollDropShadow.qml \
    qml/HeliumReborn/common/EmbossedButton.qml \
    qml/HeliumReborn/common/BottomDropShadow.qml \
    qml/HeliumReborn/common/BarIcon.qml \
    qml/HeliumReborn/common/Background.qml \
    qml/HeliumReborn/LogbookViewComponents/TabButton.qml \
    qml/HeliumReborn/LogbookViewComponents/TabBar.qml \
    qml/HeliumReborn/LogbookViewComponents/MostVisitedListView.qml \
    qml/HeliumReborn/LogbookViewComponents/LogbookListView.qml \
    qml/HeliumReborn/LogbookViewComponents/HistoryListView.qml \
    qml/HeliumReborn/LogbookViewComponents/Header.qml \
    qml/HeliumReborn/LogbookViewComponents/BookmarksListView.qml

maemo5 {
   CONFIG += link_pkgconfig
   PKGCONFIG += /usr/lib/pkgconfig/glib-2.0.pc /usr/lib/pkgconfig/gconf-2.0.pc
}

include(maemo5/maemo5.pri)

unix {
  #VARIABLES
  isEmpty(PREFIX) {
    PREFIX = /opt/usr
  }
  BINDIR = $$PREFIX/bin
  DATADIR =$$PREFIX/share

  DEFINES += DATADIR=\\\"$$DATADIR\\\" PKGDATADIR=\\\"$$PKGDATADIR\\\"

  #MAKE INSTALL

  INSTALLS += target desktop service iconxpm icon26 icon48 icon64

  target.path =$$BINDIR

  desktop.path = $$DATADIR/applications/hildon
  desktop.files += $${TARGET}.desktop

#  service.path = $$DATADIR/dbus-1/services
#  service.files += $${TARGET}.service

  icon48.path = /usr/share/icons
  icon48.files += ../data/48x48/$${TARGET}.png
}
