/*
 * headset-control: Allows for the control of the Media Player with a press of the headset button
 *
 * Copyright (C) 2010 Faheem Pervez <trippin1@gmail.com>. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *      
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *      
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 */

/* headset-controld.c */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <unistd.h>
#include <stdlib.h>
#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib.h>
#include "headset-control-obj.h"

#define USER_ID 29999

static HeadsetControl *headset_control_obj = NULL;

static void headset_control_unref_exit (GMainLoop *loop, GObject *object G_GNUC_UNUSED)
{
	if (g_main_loop_is_running (loop))
		g_main_loop_quit (loop);
}

static void sig_handler (gint sig G_GNUC_UNUSED)
{
	g_object_unref (G_OBJECT (headset_control_obj));
}

/* Thanks to whoever wrote this snippet on the BlueZ Wiki */
static void run_mainloop (GMainLoop *loop)                                                              
{                                                                          
	GMainContext *ctx = g_main_loop_get_context (loop);
	while (g_main_context_pending (ctx))
		g_main_context_iteration (ctx, FALSE);                  
}

gint main (void)
{
	GMainLoop *loop;

	if (getuid () != USER_ID)
	{
		setuid (USER_ID);
		seteuid (USER_ID);
	}

	if (!g_thread_supported ())
	{
		g_thread_init (NULL);
		dbus_g_thread_init ();
	}
	g_type_init ();

	loop = g_main_loop_new (NULL, FALSE);

	headset_control_obj = headset_control_new ();
	if (!headset_control_obj)
	{
		g_printerr ("%s\n", "HeadsetControl object instantiation failed.");
		return EXIT_FAILURE;
	}

	g_object_weak_ref (G_OBJECT (headset_control_obj), (GWeakNotify) headset_control_unref_exit, loop); 

	signal (SIGINT, sig_handler);
	signal (SIGQUIT, sig_handler);
	signal (SIGTERM, sig_handler);

	run_mainloop (loop);
	dbus_g_connection_flush (HEADSET_CONTROL_GET_CLASS (headset_control_obj)->sys_dbus_conn);
	g_main_loop_run (loop);
	g_main_loop_unref (loop);

	return EXIT_SUCCESS;
}

