/*
 * headset-control: Allows for the control of the Media Player with a press of the headset button
 *
 * Copyright (C) 2010 Faheem Pervez <trippin1@gmail.com>. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *      
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *      
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 */

/* headset-control-obj.h */

#ifndef __HEADSET_CONTROL_OBJ_H__
#define __HEADSET_CONTROL_OBJ_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib.h>
#include <gconf/gconf-client.h>
#include <libmafw/mafw.h>
#include <libmafw-shared/mafw-shared.h>

G_BEGIN_DECLS

#define HEADSET_CONTROL_SERVICE_NAME CFG_HEADSET_CONTROL_SERVICE_NAME
#define HEADSET_CONTROL_OBJECT_PATH  CFG_HEADSET_CONTROL_OBJECT_PATH
#define HEADSET_CONTROL_INTERFACE    CFG_HEADSET_CONTROL_INTERFACE_NAME

#define HEADSET_TYPE_CONTROL (headset_control_get_type ())

#define HEADSET_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
						HEADSET_TYPE_CONTROL, HeadsetControl))

#define HEADSET_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), \
						HEADSET_TYPE_CONTROL, HeadsetControlClass))

#define HEADSET_IS_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
						HEADSET_TYPE_CONTROL))

#define HEADSET_IS_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
						HEADSET_TYPE_CONTROL))

#define HEADSET_CONTROL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), \
						HEADSET_TYPE_CONTROL, HeadsetControlClass))

typedef struct _HeadsetControl HeadsetControl;
typedef struct _HeadsetControlClass HeadsetControlClass;
typedef struct _HeadsetControlPrivate HeadsetControlPrivate;

struct _HeadsetControl
{
	GObject parent;
	
	HeadsetControlPrivate *priv;
};

struct _HeadsetControlClass
{
	GObjectClass parent_class;
	
	MafwRegistry *mafw_registry;
	DBusGConnection *sys_dbus_conn;
	GConfClient *gconf_client;
};

GType headset_control_get_type (void);

HeadsetControl* headset_control_new (void);

gboolean headset_control_sixty_second_pause (HeadsetControl *, GError **);

G_END_DECLS

#endif /* __HEADSET_CONTROL_OBJ_H__ */

