#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include <string.h>
#include <stdio.h>

gchar* letters1 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
//gchar* letters2 = "QWERTYUIOPASDFGHJKLZXCVBNM";

GtkWidget* buttons[26];

GtkWidget* text = NULL;

gchar* word;
gchar* show_this;
gint failed_times = 0;

GdkPixbuf* hangman[12];
GtkWidget* image;

void show_message(gchar* text)
{
	g_critical("%s", text);
	GtkWidget* banner;
	banner = hildon_banner_show_information_with_markup(NULL, NULL, text);
	hildon_banner_set_timeout(HILDON_BANNER(banner), 5000);
}

static void new_word(GtkWidget* widget, gpointer data)
{
	failed_times = 0;
	
	int i;
	for (i = 0; i < 26; i++)
	{
		gtk_widget_set_sensitive(buttons[i], TRUE);
	}

	char tmp_str[100];
	int cpos = g_random_int()%662856;
	FILE* pFile = fopen("/opt/hangman/words.txt", "r");
	fseek(pFile, cpos, SEEK_SET);
	
	while (fgetc(pFile) != '\n')
	{
		cpos++;
		fseek(pFile, cpos, SEEK_SET);
	}
	
	cpos++;
	fseek(pFile, cpos, SEEK_SET);
	fgets(tmp_str, 100, pFile);
	
	fclose(pFile);
	
	tmp_str[strlen(tmp_str)-1] = '\0';
	
	word = "";
	word = g_strdup(tmp_str);//argv[1];
	g_print("%s\n", word);
	
	show_this = "";
	show_this = g_strnfill(strlen(word), '-');
	
	int j;
	
	for (j = 0; j < strlen(word); j++)
	{
		if (g_ascii_isalpha(word[j]))
		{
			show_this[j] = '-';
		}
		else
		{
			show_this[j] = word[j];
		}
	}
	
	gtk_label_set_text(GTK_LABEL(text), show_this);
	gtk_image_set_from_pixbuf(GTK_IMAGE(image), hangman[failed_times]);
}

static void button_clicked(GtkWidget* widget, gpointer data)
{
	gchar letter = gtk_button_get_label(GTK_BUTTON(widget))[0];
	gtk_widget_set_sensitive(widget, FALSE);
	//g_print("%c\n", letter);
	
	gint i;
	gint founded = 0;
	
	for (i = 0; i < strlen(word); i++)
	{
		if (g_ascii_toupper(word[i]) == g_ascii_toupper(letter))
		{
			show_this[i] = word[i];
			gtk_label_set_text(GTK_LABEL(text), show_this);
			//g_print("%c = %c\n", word[i], letter);
			founded++;
		}
	}
	
	if (founded == 0)
	{
		if (failed_times < 11)
		{
			failed_times++;
			//g_print("%d", failed_times);
			gtk_image_set_from_pixbuf(GTK_IMAGE(image), hangman[failed_times]);
		}
	}
	
	if (failed_times >= 11)
	{
		gtk_label_set_text(GTK_LABEL(text), word);
		gchar* message2 = g_strdup_printf("<b>You have FAILED!</b>\n<small>The word was: <i>%s</i></small>", word);
		show_message(message2);
		g_free(message2);
		
		for (i = 0; i < 26; i++)
		{
			gtk_widget_set_sensitive(buttons[i], FALSE);
		}
	}
	else if (g_strcmp0(g_ascii_strup(show_this, -1), g_ascii_strup(word, -1)) == 0)
	{
		//g_print("YOU WIN!!!");
		gchar* message = g_strdup_printf("<b>You won!</b>\n<small>The word was: <i>%s</i></small>", word);
		show_message(message);
		g_free(message);
		
		for (i = 0; i < 26; i++)
		{
			gtk_widget_set_sensitive(buttons[i], FALSE);
		}
	}
}

int main(int argc, char* argv[])
{
	hildon_gtk_init(&argc, &argv);
	
	HildonProgram* program = hildon_program_get_instance();
	GtkWidget* window = hildon_window_new();
	gtk_window_set_title(GTK_WINDOW(window), "Hangman");
	hildon_program_add_window(program, HILDON_WINDOW(window));
	hildon_gtk_window_set_portrait_flags(GTK_WINDOW(window), HILDON_PORTRAIT_MODE_REQUEST);

	g_signal_connect_swapped(G_OBJECT(window), "destroy", G_CALLBACK(gtk_main_quit), NULL);
	
	GtkWidget* table_main = gtk_table_new(3, 1, TRUE);
	
	GtkWidget* table = gtk_table_new(3, 9, TRUE);
	//GtkWidget* button;
	
	int i = 0;
	int j = 0;
	int pos = 0;
	
	for (i = 0; i < 12; i++)
	{
		GError* error = NULL;
		gchar* file = g_strdup_printf("/opt/hangman/hang%d.png", i+1);
		
		hangman[i] = gdk_pixbuf_new_from_file(file, &error);
		
		if (error)
		{
			g_critical("Cannot load file: %s", file);
			g_error_free(error);
		}
		
		g_print("%s\n", file);
		g_free(file);
	}

	for( i=0; i < 3; i++)
	{
		for( j=0; j < 9; j++)
		{
			if (pos < 26)
			{
				gchar* tmp = g_strdup_printf("%c", letters1[pos]);
				//g_print("%s\n", tmp);
				buttons[pos] = gtk_button_new_with_label(tmp);
				gtk_table_attach_defaults(GTK_TABLE(table), buttons[pos], j, j+1, i, i+1);
				g_signal_connect(buttons[pos], "clicked", G_CALLBACK(button_clicked), NULL);
				pos++;
				g_free(tmp);
			}
		}
	}
	
	text = gtk_label_new("");
	gtk_widget_modify_font(text, pango_font_description_from_string("Monospace 20"));
	
	image = gtk_image_new_from_pixbuf(hangman[0]);
	
	new_word(NULL, NULL);
	
	//gtk_table_attach_defaults(GTK_TABLE(table_main), table, 0, 1, 2, 3);
	//gtk_table_attach_defaults(GTK_TABLE(table_main), text,  0, 1, 1, 2);
	//gtk_table_attach_defaults(GTK_TABLE(table_main), image, 0, 1, 0, 1);
	
	GtkWidget* vbox_main = gtk_vbox_new(FALSE, 10);
	gtk_container_set_border_width(GTK_CONTAINER(vbox_main), 4);

	gtk_box_pack_start(GTK_BOX(vbox_main), image, FALSE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vbox_main), text,  FALSE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vbox_main), table, TRUE,  TRUE, 0);

	gtk_container_add(GTK_CONTAINER(window), vbox_main);
	gtk_widget_show_all(window);
	
	/* Create the menu */
	HildonAppMenu* menu = HILDON_APP_MENU(hildon_app_menu_new());
	
	GtkWidget* button = hildon_gtk_button_new(HILDON_SIZE_AUTO);
	gtk_button_set_label(GTK_BUTTON(button), "New game");
	g_signal_connect_after(G_OBJECT(button), "clicked", G_CALLBACK(new_word), NULL);
	hildon_app_menu_append(menu, GTK_BUTTON(button));
	
	gtk_widget_show_all(GTK_WIDGET(menu));
	
	hildon_window_set_app_menu(HILDON_WINDOW(window), menu);

	gtk_main();

	return 0;
}

