// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_TUNERCHANNEL_H
#define _GSTREAMERMM_TUNERCHANNEL_H


#include <glibmm.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstTunerChannel GstTunerChannel;
typedef struct _GstTunerChannelClass GstTunerChannelClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class TunerChannel_Class; } // namespace Gst
namespace Gst
{

/** @addtogroup gstreamermmEnums Enums and Flags */

/**
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%TunerChannelFlags operator|(TunerChannelFlags, TunerChannelFlags)</tt><br>
 * <tt>%TunerChannelFlags operator&(TunerChannelFlags, TunerChannelFlags)</tt><br>
 * <tt>%TunerChannelFlags operator^(TunerChannelFlags, TunerChannelFlags)</tt><br>
 * <tt>%TunerChannelFlags operator~(TunerChannelFlags)</tt><br>
 * <tt>%TunerChannelFlags& operator|=(TunerChannelFlags&, TunerChannelFlags)</tt><br>
 * <tt>%TunerChannelFlags& operator&=(TunerChannelFlags&, TunerChannelFlags)</tt><br>
 * <tt>%TunerChannelFlags& operator^=(TunerChannelFlags&, TunerChannelFlags)</tt><br>
 */
enum TunerChannelFlags
{
  TUNER_CHANNEL_INPUT = 1<<0,
  TUNER_CHANNEL_OUTPUT = 1<<1,
  TUNER_CHANNEL_FREQUENCY = 1<<2,
  TUNER_CHANNEL_AUDIO = 1<<3
};

/** @ingroup gstreamermmEnums */
inline TunerChannelFlags operator|(TunerChannelFlags lhs, TunerChannelFlags rhs)
  { return static_cast<TunerChannelFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline TunerChannelFlags operator&(TunerChannelFlags lhs, TunerChannelFlags rhs)
  { return static_cast<TunerChannelFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline TunerChannelFlags operator^(TunerChannelFlags lhs, TunerChannelFlags rhs)
  { return static_cast<TunerChannelFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline TunerChannelFlags operator~(TunerChannelFlags flags)
  { return static_cast<TunerChannelFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline TunerChannelFlags& operator|=(TunerChannelFlags& lhs, TunerChannelFlags rhs)
  { return (lhs = static_cast<TunerChannelFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline TunerChannelFlags& operator&=(TunerChannelFlags& lhs, TunerChannelFlags rhs)
  { return (lhs = static_cast<TunerChannelFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline TunerChannelFlags& operator^=(TunerChannelFlags& lhs, TunerChannelFlags rhs)
  { return (lhs = static_cast<TunerChannelFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::TunerChannelFlags> : public Glib::Value_Flags<Gst::TunerChannelFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{


/** Gst::TunerChannel - A channel from an element implementing the Gst::Tuner
 * interface.
 * The Gst::TunerChannel object is provided by an element implementing the
 * Gst::Tuner interface.
 *
 * Gst::TunerChannel provides a name and flags to determine the type and
 * capabilities of the channel. If the Gst::TUNER_CHANNEL_FREQUENCY flag is
 * set, then the channel also information about the minimum and maximum
 * frequency, and range of the reported signal strength.
 */

class TunerChannel : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef TunerChannel CppObjectType;
  typedef TunerChannel_Class CppClassType;
  typedef GstTunerChannel BaseObjectType;
  typedef GstTunerChannelClass BaseClassType;

private:  friend class TunerChannel_Class;
  static CppClassType tunerchannel_class_;

private:
  // noncopyable
  TunerChannel(const TunerChannel&);
  TunerChannel& operator=(const TunerChannel&);

protected:
  explicit TunerChannel(const Glib::ConstructParams& construct_params);
  explicit TunerChannel(GstTunerChannel* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~TunerChannel();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstTunerChannel*       gobj()       { return reinterpret_cast<GstTunerChannel*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstTunerChannel* gobj() const { return reinterpret_cast<GstTunerChannel*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstTunerChannel* gobj_copy();

private:


public:
  /** Get a string containing a descriptive name for this channel.
   */
   Glib::ustring get_label() const;
 
  /** Get a set of Gst::TunerChannelFlags for this channel.
   */
   TunerChannelFlags get_flags() const;
 
  /** Get the step size (in Hz) for the frequency setting.
   */
   float get_freq_multiplicator() const;
 
  /** Get the minimum valid frequency setting (in Hz).
   */
   gulong get_min_frequency() const;
 
  /** Get the maximum valid frequency setting (in Hz).
   */
   gulong get_max_frequency() const;
 
  /** Get the minimum reported signal strength value.
   */
   int get_min_signal() const;
 
  /** Get the maximum reported signal strength value.
   */
   int get_max_signal() const;
 
  /** Reports that the current frequency has changed.
   * @param frequency The new frequency.
   *
   * @par Prototype:
   * <tt>void on_my_%frequency_changed(gulong frequency)</tt>
   */

  Glib::SignalProxy1< void,gulong > signal_frequency_changed();


  /** Reports that the signal strength has changed.
   * @param signal The new signal value.
   *
   * @par Prototype:
   * <tt>void on_my_%signal_changed(int signal)</tt>
   */

  Glib::SignalProxy1< void,int > signal_signal_changed();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_frequency_changed(gulong frequency);
  virtual void on_signal_changed(int signal);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::TunerChannel
   */
  Glib::RefPtr<Gst::TunerChannel> wrap(GstTunerChannel* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_TUNERCHANNEL_H */

