#include <X11/Xos.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <stdio.h>
#include "config.h"
#include "DviP.h"

int
DviGetAndPut(dw, cp)
    DviWidget	dw;
    int		*cp;
{
	if (dw->dvi.ungot) {
		dw->dvi.ungot =	0;
		*cp = getc (dw->dvi.file);
	}
	else {
		*cp = getc (dw->dvi.file);
		if (*cp != EOF)
			putc (*cp, dw->dvi.tmpFile);
	}
	return *cp;
}

char *
GetLine(dw, Buffer, Length)
	DviWidget	dw;
	char	*Buffer;
	int	Length;
{
	int 	i = 0, c;
	
	Length--;		     /* Save room for final '\0' */
	
	while (DviGetC (dw, &c) != EOF) {
		if (Buffer && i < Length)
			Buffer[i++] = c;
		if (c == '\n') {
			DviUngetC(dw, c);
			break;
		}
	}
	if (Buffer)
		Buffer[i] = '\0';
	return Buffer;
} 

char *
GetWord(dw, Buffer, Length)
	DviWidget	dw;
	char	*Buffer;
	int	Length;
{
	int 	i = 0, c;
	
	Length--;			    /* Save room for final '\0' */
	while (DviGetC(dw, &c) == ' ' || c == '\n')
		;
	while (c != EOF) {
		if (Buffer && i < Length)
			Buffer[i++] = c;
		if (DviGetC(dw, &c) == ' ' || c == '\n') {
			DviUngetC(dw, c);
			break;
		}
	}
	if (Buffer)
		Buffer[i] = '\0';
	return Buffer;
} 

int
GetNumber(dw)
	DviWidget	dw;
{
	int	i = 0,  c;
	int	negative = 0;

	while (DviGetC(dw, &c) == ' ' || c == '\n')
		;
	if (c == '-') {
		negative = 1;
		DviGetC(dw, &c);
	}

	for (; c >= '0' && c <= '9'; DviGetC(dw, &c)) {
		if (negative)
			i = i*10 - (c - '0');
		else
			i = i*10 + c - '0';
	}
	if (c != EOF)
		DviUngetC(dw, c);
	return i;
}

#ifdef ENABLE_MULTIBYTE
#include <locale.h>
#include <langinfo.h>
#include <iconv.h>
#include <errno.h>

static iconv_t icd;
void
DviInitLocale()
{
	char *enc;
	setlocale(LC_ALL, "");
	enc = nl_langinfo(CODESET);
	icd = iconv_open("UCS-2BE", enc);
}

int
DviGetCharacter(dw, cp)
	DviWidget	dw;
	char   *cp;
{
	char inbuf[8];
	char outbuf[8];
	char *inp, *outp;
	size_t inbytesleft, outbytesleft = 8;
	int i = 0;
	int j;
	int wc = 0;
	int c;
	size_t r;

	while (wc == 0) {
		DviGetC(dw, &c);
		if (c == EOF)
			return EOF;
		inbuf[i++] = c;
		inbytesleft = i;
		outbytesleft = BUFSIZ;
		inp = inbuf;
		outp = outbuf;
		r = iconv(icd, &inp, &inbytesleft, &outp, &outbytesleft);
		if (r == (size_t)-1) {
			if (errno == EILSEQ) {
				/* illegal sequence */
			} else if (errno == EINVAL) {
				/* incomplete sequence */
				continue;
			} else if (errno == E2BIG) {
				/* no room to output? */
				
			}
			DviUngetC(dw, c);
		}
		/* ok - pass inbuf to cp */
		for (j = 0; j < i; j++) {
			cp[j] = inbuf[j];
		}
		cp[j] = '\0';
		return i;
	}
	/* NOT REACHED */
}

int
DviWCharP(char *name, int *wc)
{
	char outbuf[BUFSIZ];
	char *inp, *outp;
	int inbytesleft, outbytesleft;
	size_t r;
	*wc = 0;
	inp = name;
	inbytesleft = strlen(name);
	outp = outbuf;
	outbytesleft = sizeof(outbuf)-1;
	r = iconv(icd, &inp, &inbytesleft, &outp, &outbytesleft);
	if (r < 0) {
		return 0;
	}
	/* UCS-2 check */
	if (outbuf + 2 != outp) {
		return 0;
	}
	for (inp = outbuf; inp < outp; inp++) {
		*wc <<= 8;
		*wc |= (*inp) & 0x0ff;
	}
	return 1;
}

#endif
	
/*
Local Variables:
c-indent-level: 8
c-continued-statement-offset: 8
c-brace-offset: -8
c-argdecl-indent: 8
c-label-offset: -8
c-tab-always-indent: nil
End:
*/
