#!/usr/bin/env python
# -*- coding: utf-8 -*-
'''
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

    Copyright (C) 2010 Nikiforakis Manos (nikiforakis.m@gmail.com)
    
    Modified by Giorgos Logiotatidis (seadog@sealabs.net)
    Original Mano's post: http://emnik.wordpress.com/2010/01/12/playlist-%CE%BC%CE%B5-%CF%84%CE%BF%CF%85%CF%82-%CF%81%CE%B1%CE%B4%CE%B9%CE%BF%CF%86%CF%89%CE%BD%CE%B9%CE%BA%CE%BF%CF%8D%CF%82-%CF%83%CF%84%CE%B1%CE%B8%CE%BC%CE%BF%CF%8D%CF%82-%CF%84%CE%BF%CF%85-e-ra-2/
    Giorgos Updated post: http://www.sealabs.net/seadog/2010/01/playlist-για-το-eradio-gr-version-4
    
'''

import re
import urllib


def getPlaylist(quiet=True):
    pls = {}
    HTML = urllib.urlopen("http://www.e-radio.gr").read()

    if not quiet:
        print 'Wait while fetching www.e-radio.gr and adding radio stations in playlist...'


    stationIDS = re.findall("javascript:openplayer\((\d+)\);", HTML, re.IGNORECASE)
    for id in stationIDS:
        page = urllib.urlopen("http://www.e-radio.gr/player/player.el.asp?sid=%s" % id).read()
        stationURL = re.search("playerX.asp\?sID=\d+&cn=([\w\d]+)", page)
        if stationURL == None:
            continue

        stationurl= "http://eradio.gr/asx/%s.asx" %(stationURL.group(1))
        a=urllib.urlopen(stationurl).read()
        checkstation=re.compile('Server Error')
        checkresult = checkstation.findall(a)
        if len(checkresult)>0:
        #	print checkresult[0], stationurl;
        	pass
        else:            
            #Get the TITLE
            title_re=re.compile('(<TITLE>)(.*?)(</TITLE>)')
            title=title_re.findall(a)
            title = unicode(title[0][1], 'iso8859-7').encode('utf-8')
            if not quiet:
                print 'Added %s' %(title)
            #Get the URI
            mms_re=re.compile('''("[http|mms].*?")''')
            mms=mms_re.findall(a)
            mms_uri= mms[1].strip('''"''') # 0 for http,  1 for mms
            #print "File%d=%s" %(k,mms_uri)
            pls["GRE - " + title] = mms_uri

    return pls


if __name__ == "__main__":
    pls = getPlaylist(quiet=False)
    playlist_file=open('eradio.pls', 'w')
    playlist_file.write("[Playlist]\n")
    playlist_file.write("NumberOfEntries=%d\n" %(len(pls)))

    k=1
    for station in sorted(pls.keys()):
        playlist_file.write("Title%s=%s\n" % (k, station))
    	playlist_file.write("File%s=%s\n" % (k, pls[station]))
    	k += 1

    playlist_file.close()

