#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "loadprev.h"
QString game;
QString cfg_path="/home/user/.config/Team16/gpsp/";
QString bios_path="/home/user/MyDocs/";
QString rom_path="/home/user/MyDocs";
MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
settings=new QSettings();
bios_path=settings->value("bios_path","/home/user/MyDocs/").toString();
if (bios_path.right(1)!="/")bios_path+="/";
 rom_path=settings->value("rom_path","/home/user/MyDocs/").toString();
 if (rom_path.right(1)!="/")rom_path+="/";

    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    cfg=new options(this);
    cfg->hide();
    game="";
    cfg->load_cfg();


     QDir cfg_dir(cfg_path);
     if (!cfg_dir.exists()){
         if (!cfg_dir.mkdir(cfg_path))
             qDebug("Can't create cfg dir, permission error?");
         else
             cfg->save_cfg();

     }

    QDir dir(rom_path);
         dir.setFilter(QDir::Files);
         dir.setSorting(QDir::Name);
         dir.setNameFilters(QStringList()<<"*.bin"<<"*.gba"<<"*.zip");

         QFileInfoList list = dir.entryInfoList();
         int o=0;
         for (int i = 0; i < list.size(); ++i) {
             QFileInfo fileInfo = list.at(i);
             if (fileInfo.fileName()=="gba_bios.bin")continue;
             ui->listWidget->addItem(new QListWidgetItem(fileInfo.fileName()));
             roms.insert(o++,fileInfo.absoluteFilePath());
         }

connect (ui->pushButton_2,SIGNAL(clicked()),this,SLOT(rom_config()));
connect (ui->pushButton,SIGNAL(clicked()),this,SLOT(rom_exec()));


this->menuBar()->addAction("Default config",this,SLOT(def_cfg()));
this->menuBar()->addAction("GUI config",this,SLOT(gui_cfg()));
this->menuBar()->addAction("Configure keys",this,SLOT(set_keys()));
this->menuBar()->addAction("Help",this,SLOT(open_help()));

connect(ui->listWidget,SIGNAL(currentRowChanged(int)),this,SLOT(currentRowChanged(int)));
}

void MainWindow::rom_exec(){
QProcess *myProcess = new QProcess();
QStringList args=current_config;
args<<roms.value(ui->listWidget->currentRow());
qDebug (QString("%1 %2").arg("/opt/maemo/usr/games/gpspm").arg(args.join(" ")).toAscii());
myProcess->startDetached("/opt/maemo/usr/games/gpspm", args,"/opt/gpspm/");
}

void MainWindow::currentRowChanged ( int currentRow ){
    if (ui->listWidget->currentRow()!=-1){
        game="";
        cfg->load_cfg();
        game=ui->listWidget->currentItem()->text();
        cfg->load_cfg();
    }
}

void MainWindow::set_keys(){
    keyopt=new keys(this);
    keyopt->show();
    keyopt=NULL;
}

void MainWindow::def_cfg()
{
game="";
cfg->setWindowTitle("Config: default");
cfg->show();
}

void MainWindow::gui_cfg()
{
    QDialog *dlg=new QDialog(this);
    QGridLayout *lay=new QGridLayout(dlg);
    QPushButton *btn1=new QPushButton(tr("Rom directory"),dlg);
    QPushButton *btn2=new QPushButton(tr("Copy bios"),dlg);
    connect (btn1,SIGNAL(clicked()),this,SLOT(set_rom_dir()));
    connect (btn2,SIGNAL(clicked()),this,SLOT(set_bios_dir()));
    lay->addWidget(btn1,1,0);
    lay->addWidget(btn2 ,2,0);
    dlg->exec();
    dlg=NULL;
}

void MainWindow::set_rom_dir(){
    QString dir=QFileDialog::getExistingDirectory(this,tr("ROM Directory"),"/home/user/MyDocs/");
    QString rom_path=dir;
    settings->setValue("rom_path",rom_path);


}
void MainWindow::set_bios_dir(){
    QString fileName = QFileDialog::getOpenFileName(this, tr("Gba bios"),"/home/user/MyDocs",tr("Gba bios (gba_bios.bin)"));
    if (fileName!="") QFile::copy(fileName,"/opt/gpspm/gba_bios.bin");

}

void MainWindow::open_help()
{
    QDesktopServices::openUrl(QUrl("http://maemo.team16.ru/index.php?page=8"));
}



MainWindow::~MainWindow()
{
    delete ui;
}


void MainWindow::rom_config(){
    if (ui->listWidget->currentRow()!=-1){
        cfg->setWindowTitle("Config:"+game);
        cfg->show();
}

}
