#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>

#include "keys.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    enum ScreenOrientation {
        ScreenOrientationLockPortrait,
        ScreenOrientationLockLandscape,
        ScreenOrientationAuto
    };

    explicit MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();

    // Note that this will only have an effect on Symbian and Fremantle.
    void setOrientation(ScreenOrientation orientation);

    void showExpanded();

public slots:

    void set_keys();
    void emu_exec();

private slots:
    void on_Configure_Buttons_clicked();

    void on_StartEmulator_clicked();

    void on_Download_clicked();

private:
    keys *keyopt;
    Ui::MainWindow *ui;
};

#endif // MAINWINDOW_H
