//Code Stolen from psx4m-gui with small edition of QKeyEvent
//as well as their respective names to better match the purpose
//of this Ui.

#include "keys.h"

void sh_key::keyPressEvent ( QKeyEvent * event ){
this->setText(QString("%1").arg(event->nativeScanCode()));

    QMap<int,QString> keys;
    keys.insert(37,"ctrl");
    keys.insert(24,"q");
    keys.insert(25,"w");
    keys.insert(26,"e");
    keys.insert(27,"r");
    keys.insert(28,"t");
    keys.insert(29,"y");
    keys.insert(30,"u");
    keys.insert(31,"i");
    keys.insert(32,"o");
    keys.insert(33,"p");
    keys.insert(59,",");
    keys.insert(22,"backspace");

    keys.insert(108,"function");
    keys.insert(38,"a");
    keys.insert(39,"s");
    keys.insert(40,"d");
    keys.insert(41,"f");
    keys.insert(42,"g");
    keys.insert(43,"h");
    keys.insert(44,"j");
    keys.insert(45,"k");
    keys.insert(46,"l");
    keys.insert(60,"dot");
    keys.insert(111,"up");
    keys.insert(36,"enter");



    keys.insert(50,"shift");
    keys.insert(52,"z");
    keys.insert(53,"x");
    keys.insert(54,"c");
    keys.insert(55,"v");
    keys.insert(56,"b");
    keys.insert(57,"n");
    keys.insert(58,"m");
    keys.insert(65,"space");
    keys.insert(113,"Left");
    keys.insert(116,"Down");
    keys.insert(114,"Right");

    event->ignore();

}

sh_key::sh_key(QWidget *parent) :
        QLineEdit(parent)
{
    this->setAlignment(Qt::AlignCenter);
}

keys::keys(QWidget *parent) :
        QWidget(parent)
{

 ks=QStringList()<<tr("Escape (Gui)")<<tr("Down (Gui)")<<tr("Up (Gui)")
                <<tr("Left (Gui)")<<tr("Right (Gui)")<<tr("Select (Gui)")<<tr("Back ( Gui )")
                                <<tr("L")<<tr("R")<<tr("Down")
                                <<tr("Up")<<tr("Left")<<tr("Right")<<tr("Start")<<tr("Select")
                                <<tr("B")<<tr("A");

this->setWindowFlags(this->windowFlags() | Qt::Window);
this->setAttribute(Qt::WA_Maemo5StackedWindow);
QScrollArea *area=new QScrollArea(this);
QVBoxLayout *lay=new QVBoxLayout(this);
lay->addWidget(area);
QWidget *wg=new QWidget();
area->setWidget(wg);
wg->setMinimumSize(600,1200);
QGridLayout *grid=new QGridLayout(wg);
wg->show();
area->show();
grid->setHorizontalSpacing(25);
grid->setVerticalSpacing(25);

// load current

QFile file("/opt/gpsp/conf.gpsp");
if (!file.open(QIODevice::ReadOnly | QIODevice::Text)){
    QMessageBox msg;
    msg.setText(tr("Couldn't open previous key config"));
    msg.exec();
}

int o=0;
     QTextStream in(&file);
     while ((o<ks.count())) {
         QString line="0";
         if (!in.atEnd())
         line = in.readLine();

         QLabel *lbl=new QLabel(ks.at(o),wg);
         grid->addWidget(lbl,o,1,1,1);

         nkey[o]=new sh_key(wg);
         nkey[o]->setParent(wg);
         nkey[o]->setMinimumSize(150,60);

         grid->addWidget(nkey[o],o,0,1,1);
         grid->setRowMinimumHeight(o,80);
         nkey[o]->show();
         nkey[o]->setText(line.trimmed());
         o++;
     }

}
void keys::hideEvent(QHideEvent *){
    if (!this->isVisible()){
        QDialog *dlg=new QDialog(this);
        QGridLayout *lay=new QGridLayout(dlg);
        QLabel *lbl=new QLabel(tr("Do you want to save settings?"),dlg);
        lay->addWidget(lbl,1,0,1,2);
        QPushButton *yes=new QPushButton(tr("Yes"),dlg);
        QPushButton *no=new QPushButton(tr("No"),dlg);
        connect (yes,SIGNAL(clicked()),dlg,SLOT(accept()));
        connect (no,SIGNAL(clicked()),dlg,SLOT(reject()));
        connect (dlg,SIGNAL(accepted()),this,SLOT(save()));
        lay->addWidget(yes,2,0);
        lay->addWidget(no ,2,1);
        dlg->exec();
    }
}

void keys::save(){
QString sv="";
for (int i=0;i<ks.count();i++)
    sv=sv+QString("%1\n").arg(nkey[i]->text());

QFile file("/opt/gpsp/conf.gpsp");
if (!file.open(QIODevice::WriteOnly | QIODevice::Text)){
    QMessageBox msg;
    msg.setText("Your conf.gpsp file needs the right permissions, set it please.");
    msg.exec();
    return;}

     QTextStream out(&file);
     out <<sv;

}

keys::~keys()
{

}
