/*
 *  GPSData for Maemo.
 *  Copyright (C) 2011 Roman Moravcik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef SATELLITESIGNALSTRENGTH_H
#define SATELLITESIGNALSTRENGTH_H

#include <QWidget>

#include <QGeoSatelliteInfo>

QTM_USE_NAMESPACE

class SatelliteSignalStrength : public QWidget
{
  Q_OBJECT

public:
    SatelliteSignalStrength(QWidget *parent = 0);

    void updateWidget(const QList<QGeoSatelliteInfo> &satellites, bool inUseList);
    void showTitle(bool show);

private:
    bool m_showTitle;
    static const int m_margin = 8;
    static const int m_spacing = 8;
    static const int m_numOfSatellites = 32;
    static const int m_numOfRows = 2;
    static const int m_numOfSatellitesInRow = m_numOfSatellites / m_numOfRows;

    QColor m_barGraphBorderColor;
    QColor m_barGraphBackgroundColor;
    QColor m_barGraphInViewColor;
    QColor m_barGraphInUseColor;

    QList<QGeoSatelliteInfo> m_satellitesInView;
    QList<QGeoSatelliteInfo> m_satellitesInUse;

    void paintTitle(QPainter &painter, const QRectF &area);
    void paintBarGraph(QPainter &painter, const QRectF &area, int index);

protected:
    void paintEvent(QPaintEvent *event);
};

#endif // SATELLITESIGNALSTRENGTH_H
