/*
 *  GPSData for Maemo.
 *  Copyright (C) 2011 Roman Moravcik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <QtGui>

#include "gpscompasswindow.h"

GpsCompassWindow::GpsCompassWindow(QWidget *parent) : QMainWindow(parent)
{
    m_screenLocked = false;

    createUi();

    connect(parent, SIGNAL(screenLocked(bool)), this, SLOT(onScreenLocked(bool)));
}

GpsCompassWindow::~GpsCompassWindow()
{
    delete m_compass;
}

void GpsCompassWindow::createUi()
{
#if defined(Q_OS_SYMBIAN)
    setAttribute(Qt::WA_DeleteOnClose);
#elif defined(Q_WS_MAEMO_5)
    setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
    setAttribute(Qt::WA_Maemo5StackedWindow);

    /* Workaround to show compass widget maximized */
    showMaximized();
#endif

    setWindowTitle(tr("GPS compass"));

    m_compass = new Compass(Compass::Gps);
    setCentralWidget(m_compass);

#ifdef Q_OS_SYMBIAN
    QAction* backSoftkey = new QAction(tr("Back"), this);
    backSoftkey->setSoftKeyRole(QAction::NegativeSoftKey);
    connect(backSoftkey, SIGNAL(triggered()), this, SLOT(close()));
    addAction(backSoftkey);
#endif
}

void GpsCompassWindow::onScreenLocked(bool locked)
{
    m_screenLocked = locked;
}

void GpsCompassWindow::onPositionUpdated(const QGeoPositionInfo &position)
{
    if (m_screenLocked)
        return;

    if (position.hasAttribute(QGeoPositionInfo::Direction)) {
        m_compass->updateWidget(position.attribute(QGeoPositionInfo::Direction), true,
                                position.attribute(QGeoPositionInfo::GroundSpeed));
    } else {
        m_compass->updateWidget(0, false, 0);
    }
}

void GpsCompassWindow::setPositionInfoSource(QGeoPositionInfoSource *positionInfoSource)
{
    m_position = positionInfoSource;
    if (m_position) {
        connect(m_position, SIGNAL(positionUpdated(const QGeoPositionInfo &)), this,
                SLOT(onPositionUpdated(const QGeoPositionInfo &)));

        m_position->requestUpdate();
    }
}
