/*
 * Copyright (C) 2005 Luca De Cicco <ldecicco@gmail.com>
 * Hildonized by Luca De Cicco
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#include "sudoku_worksheet.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <libintl.h>

#ifdef IS_HILDON

#if IS_HILDON == 3
/* Hildon includes */
#include <hildon/hildon.h>

#include <hildon-widgets/gtk-infoprint.h>
#include <hildon-widgets/hildon-appview.h>
#include <hildon-fm/hildon-widgets/hildon-file-chooser-dialog.h>
#endif 
#if IS_HILDON == 4
#include <hildon/hildon.h>
#endif 

#include <libosso.h>
#define APPLICATION_DBUS_SERVICE "gpe_sudoku"

#else //IS_HILDON
#include <gpe/infoprint.h>
#endif 




#define _(_x) gettext (_x)
GtkWidget* create_window1 (void);

void draw_all_squares();
gboolean cell_pressed(gint selected);
void draw_big_square(struct sudoku_big_square *bs);

struct cell {
	GtkWidget *entry;
	GdkPoint coord;
};
