import os
import sys
from PySide.QtCore import *
from PySide.QtGui import *

COMMENT_CHAR = '#'
OPTION_CHAR =  ' '
HOME = os.path.expanduser("~")
GNGEO_CFG_FILE = HOME + '/.gngeo/gngeorc'
GNGEOGUI_CFG_FILE = HOME + '/.gngeo-gui/gngeo-gui.cfg'
buttons = ""
BiosPath = ""
RomrcPath = ""
RomPath = ""
ExecPath = ""

def parse_config(self, filename):
        options = {}
        f = open(filename)
        for line in f:
            # First, remove comments:
            if COMMENT_CHAR in line:
                # split on comment char, keep only the part before
                line, comment = line.split(COMMENT_CHAR, 1)
            # Second, find lines with an option=value:
            if OPTION_CHAR in line:
                 # split on option char:
                 option, value = line.split(OPTION_CHAR, 1)
                 # strip spaces:
                 option = option.strip()
                 value = value.strip()
                 # store in dictionary:
                 options[option] = value
        f.close()
        return options



class Ui_MainWindow(QWidget):
    def __init__(self):
        QWidget.__init__(self, None)
        self.resize(800, 480)
        self.setWindowTitle("GnGeo-gui")
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
	'''
	Check for required files
	'''
        self.gui_opts = parse_config(self,GNGEOGUI_CFG_FILE)
	if not "exec_path" in self.gui_opts:
		QMessageBox.critical(self, "Critical",  "exec_path not set in '" + GNGEOGUI_CFG_FILE + "'")
    		sys.exit()
	if not os.path.isfile(self.gui_opts["exec_path"] + "/gngeo"):
		QMessageBox.critical(self, "Critical",  "'" + self.gui_opts["exec_path"] + "/gngeo' not found!")
        	widget = pathWindow(self)
		widget.show()
	try:
	        open(GNGEO_CFG_FILE ,"r")
	except:
		QMessageBox.critical(self, "Critical", "Config file '" + GNGEO_CFG_FILE + "' not readable!")
    		sys.exit()
	# Load config
        self.options = parse_config(self,GNGEO_CFG_FILE)
	myPaths = [ "rompath", "biospath", "romrcdir" ]
	for myPath in myPaths:
		if not os.path.isdir(self.options[myPath]):
			QMessageBox.critical(self, "Critical",  myPath + " '" + self.options[myPath] + "' not found!")
        		widget = pathWindow(self)
			widget.show()
	if not (os.path.exists(self.options["biospath"] + "/sfix.sfx")) \
	and not (os.path.exists(self.options["biospath"] + "/sfix.sfix")):
		QMessageBox.critical(self, "Warning",  "Cannot find all bios files in " + self.options["biospath"])
	if not os.path.exists(self.options["romrcdir"] + "/kof96.rc"):
		QMessageBox.critical(self, "Warning",  "Cannot find romrc files in " + self.options["romrcdir"])
	# Set background image
        backgroundLabel = QLabel(self)
        AboutTxt = "<img src=/opt/gngeo-gui/neogeo_background.png />" 
        backgroundLabel.setText(AboutTxt)
	backgroundLabel.setAlignment(Qt.AlignCenter | Qt.AlignLeft)
	# Get Gametitles from rompath
	ListCmd = self.gui_opts["exec_path"] + "/gngeo --scandir=" + self.options["rompath"] 
	fin,fout = os.popen4(ListCmd)
	romList = fout.read()
	romList = romList.replace('\n',':\n')
	romList = romList.split(':')
	# Remove header in romlist
	romList = romList[3:-1]
	if not romList:
		Games = "No roms found! "
	else:
		Games = ""
	Teller = 1
	GameFile = ""
	for Item in romList:
		if Item[0] != "\n":
			if Teller == 0:
				GameFile = GameFile + Item + ":"
				Teller = 1
			else:
				Games = Games + Item + ":"
				Teller = 0
	# Remove the last ":"
	Games = Games[:-1]
	GameFile = GameFile[:-1]
	Games = Games.split(":")
	self.GameFile = GameFile.split(":")
        self.combo = QComboBox(self)
        self.combo.setStyleSheet( \
	"QComboBox { color: gray; \
	 border: 6px solid #045FB4; \
	 border-radius: 3px; \
	 min-width: 6em; \
	 }" )
	self.combo.setGeometry(QRect(170, 230, 450, 60))
	for Game in Games:
        	self.combo.addItem(Game)

        self.startButton = QPushButton("Start",self)
        self.startButton.setGeometry(QRect(0, 370, 200, 55))
        font = QFont()
        font.setPointSize(24)
        self.startButton.setFont(font)
	QObject.connect(self.startButton
		, SIGNAL("clicked()")
		, self.on_start_clicked)

        self.muteCheckBox = QCheckBox("Mute",self)
        self.muteCheckBox.setGeometry(QRect(200, 370, 200, 55))
        font = QFont()
        font.setPointSize(24)
        self.muteCheckBox.setFont(font)
	if self.options["sound"] == "true":
            self.muteCheckBox.setChecked(False)
	else:
            self.muteCheckBox.setChecked(True)

        self.configButton = QPushButton("Config",self)
        self.configButton.setGeometry(QRect(400, 370, 200, 55))
        font = QFont()
        font.setPointSize(24)
        self.configButton.setFont(font)
	QObject.connect(self.configButton
		, SIGNAL("clicked()")
		, self.slotConfig)

        self.pushAboutButton = QPushButton("About",self)
        self.pushAboutButton.setGeometry(QRect(600, 370, 200, 55))
        self.pushAboutButton.setFont(font)
	QObject.connect(self.pushAboutButton
		, SIGNAL("clicked()")
		, self.slotAbout)


    def on_start_clicked(self):
	gameNbr = self.combo.currentIndex()
	self.gameFile = self.GameFile[gameNbr]
        if self.muteCheckBox.isChecked():
               SOUND_OPT=" --no-sound "
        else:  SOUND_OPT=" --sound " 
	if self.gameFile:
		QProcess.startDetached(self.gui_opts["exec_path"]+"/gngeo "+SOUND_OPT+self.options["rompath"]+'/'+self.gameFile)

    def slotAbout(self):
        a = AboutWindow(self)
        a.show()

    def slotConfig(self):
        a = ConfigWindow(self)
        a.show()

class AboutWindow(QMainWindow):
    def __init__(self, parent):
        QMainWindow.__init__(self, parent)
        self.setWindowTitle("About GnGeo-gui")
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.setAttribute(Qt.WA_DeleteOnClose)
        self.label = QLabel(self)
        AboutTxt = "<h3>Gngeo-gui</h3><p>" \
                   "<img src=/opt/usr/share/icons/hicolor/64x64/apps/gngeo_gui.png /><br>" \
                   "GnGeo-gui is a Graphical User Interface for GnGeo<p> " \
                   "GnGeo emulates the NeoGeo gameconsole from SNK &#174;</p>" \
                   "<p>GnGeo-gui is written in PySide by <i>Arno Dekker<\i>" 
        self.label.setText(AboutTxt)
	self.label.setAlignment(Qt.AlignCenter | Qt.AlignLeft)
      	self.setCentralWidget(self.label)

class ConfigWindow(QMainWindow):
    def __init__(self, parent):
        QMainWindow.__init__(self, parent)
        self.setWindowTitle("Configuration GnGeo-gui")
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.setAttribute(Qt.WA_DeleteOnClose)
        self.options = parse_config(self,GNGEO_CFG_FILE)
        font = QFont()
        font.setPointSize(20)
	#showfps
        self.showfpsCheckBox = QCheckBox("Showfps",self)
        self.showfpsCheckBox.setGeometry(QRect(18, 15, 250, 60))
        self.showfpsCheckBox.setFont(font)
	if self.options["showfps"] == "true":
            self.showfpsCheckBox.setChecked(True)
	#fullscreen
        self.fullscreenCheckBox = QCheckBox("Fullscreen",self)
        self.fullscreenCheckBox.setGeometry(QRect(273, 15, 250, 60))
        self.fullscreenCheckBox.setFont(font)
	if self.options["fullscreen"] == "true":
            self.fullscreenCheckBox.setChecked(True)
	#sound
        self.soundCheckBox = QCheckBox("Sound",self)
        self.soundCheckBox.setGeometry(QRect(530, 15, 250, 60))
        self.soundCheckBox.setFont(font)
	if self.options["sound"] == "true":
            self.soundCheckBox.setChecked(True)
	#autoframeskip
        self.autoframeskipCheckBox = QCheckBox("Autoframeskip",self)
        self.autoframeskipCheckBox.setGeometry(QRect(18, 85, 250, 60))
        self.autoframeskipCheckBox.setFont(font)
	if self.options["autoframeskip"] == "true":
            self.autoframeskipCheckBox.setChecked(True)
	#raster
        self.rasterCheckBox = QCheckBox("Raster",self)
        self.rasterCheckBox.setGeometry(QRect(273, 85, 250, 60))
        self.rasterCheckBox.setFont(font)
	if self.options["raster"] == "true":
            self.rasterCheckBox.setChecked(True)
	#interpolation
        self.interpolationCheckBox = QCheckBox("Interpolation",self)
        self.interpolationCheckBox.setGeometry(QRect(530, 85, 250, 60))
        self.interpolationCheckBox.setFont(font)
	if self.options["interpolation"] == "true":
            self.interpolationCheckBox.setChecked(True)
	#sleepidle
        self.sleepidleCheckBox = QCheckBox("Sleepidle",self)
        self.sleepidleCheckBox.setGeometry(QRect(18, 170, 250, 60))
        self.sleepidleCheckBox.setFont(font)
	if self.options["sleepidle"] == "true":
            self.sleepidleCheckBox.setChecked(True)
	#hwsurface
        self.hwsurfaceCheckBox = QCheckBox("Hwsurface",self)
        self.hwsurfaceCheckBox.setGeometry(QRect(273, 170, 250, 60))
        self.hwsurfaceCheckBox.setFont(font)
	if self.options["hwsurface"] == "true":
            self.hwsurfaceCheckBox.setChecked(True)
	#joystick
        #self.joystickCheckBox = QCheckBox("Joystick",self)
        #self.joystickCheckBox.setGeometry(QRect(530, 170, 250, 60))
        #self.joystickCheckBox.setFont(font)
	#if self.options["joystick"] == "true":
        #    self.joystickCheckBox.setChecked(True)
	#system
	label = QLabel("<i>system:</i>", self)
	label.move(100,230)
        self.comboSystem = QComboBox(self)
	self.comboSystem.setGeometry(QRect(18, 260, 250, 60))
	systems = self.listDefaultFirst("system",['arcade','home'])
	for sysType in systems:
       		 	self.comboSystem.addItem(sysType)
	#country
	label = QLabel("<i>region:</i>", self)
	label.move(335,230)
        self.comboCountry = QComboBox(self)
	self.comboCountry.setGeometry(QRect(270, 260, 250, 60))
	countries = self.listDefaultFirst("country",['japan', 'usa', 'europe'])
	for Location in countries:
       		 	self.comboCountry.addItem(Location)
	#effect
	label = QLabel("<i>effect:</i>", self)
	label.move(595,230)
        self.comboEffect = QComboBox(self)
	self.comboEffect.setGeometry(QRect(530, 260, 250, 60))
	effects = self.listDefaultFirst("effect",['none', 'scanline', 'scanline50', 'scale2x', 'scale3x', 'scale4x', 'scale2x50', 'scale2x75', 'hq2x', 'hq3x', 'lq2x', 'lq3x', 'doublex'])
	for effect in effects:
       		 	self.comboEffect.addItem(effect)
	# Keys button
        self.keysButton = QPushButton("keys",self)
        self.keysButton.setGeometry(QRect(18, 330, 250, 80))
	QObject.connect(self.keysButton
		, SIGNAL("clicked()")
		, self.on_keys_clicked)
	# Path button
        self.keysButton = QPushButton("paths",self)
        self.keysButton.setGeometry(QRect(273, 330, 250, 80))
	QObject.connect(self.keysButton
		, SIGNAL("clicked()")
		, self.on_paths_clicked)
	# Samplerate
	label = QLabel("<i>snd_rate:</i>", self)
	label.move(595,145)
        self.comboSampleRate = QComboBox(self)
	self.comboSampleRate.setGeometry(QRect(530, 170, 250, 60))
	Sam_Rates = self.listDefaultFirst("samplerate",['8192','11025','22050','32000','44100','48000'])
	for SampRate in Sam_Rates:
		self.comboSampleRate.addItem(SampRate)
	# Save button
        self.saveButton = QPushButton("SAVE",self)
        self.saveButton.setStyleSheet(
	"QPushButton { color: red; font:bold; }"
      		) 
        self.saveButton.setGeometry(QRect(530, 330, 250, 80))
	QObject.connect(self.saveButton
		, SIGNAL("clicked()")
		, self.on_save_clicked)


    def on_save_clicked(self):
        if self.soundCheckBox.isChecked():
           self.options["sound"] = "true"
        else: self.options["sound"] = "false" 
        if self.showfpsCheckBox.isChecked():
           self.options["showfps"] = "true"
        else: self.options["showfps"] = "false" 
        if self.fullscreenCheckBox.isChecked():
           self.options["fullscreen"] = "true"
        else: self.options["fullscreen"] = "false" 
        if self.autoframeskipCheckBox.isChecked():
           self.options["autoframeskip"] = "true"
        else: self.options["autoframeskip"] = "false" 
        if self.rasterCheckBox.isChecked():
           self.options["raster"] = "true"
        else: self.options["raster"] = "false" 
        if self.interpolationCheckBox.isChecked():
           self.options["interpolation"] = "true"
        else: self.options["interpolation"] = "false" 
        if self.sleepidleCheckBox.isChecked():
           self.options["sleepidle"] = "true"
        else: self.options["sleepidle"] = "false" 
        if self.hwsurfaceCheckBox.isChecked():
           self.options["hwsurface"] = "true"
        else: self.options["hwsurface"] = "false" 
        #if self.joystickCheckBox.isChecked():
        #   self.options["joystick"] = "true"
        #else: self.options["joystick"] = "false" 
	self.options["system"] = self.comboSystem.currentText()
	self.options["country"] = self.comboCountry.currentText()
	self.options["effect"] = self.comboEffect.currentText()
	self.options["samplerate"] = self.comboSampleRate.currentText()
	if BiosPath != "":
		self.options["biospath"] = BiosPath
	if RomrcPath != "":
		self.options["romrcdir"] = RomrcPath
	if RomPath != "":
		self.options["rompath"] = RomPath
	if ExecPath != "":
		try:
			ConfigFile = open(GNGEOGUI_CFG_FILE,"w")
		except:
			QMessageBox.critical(self, "Warning",  "Cannot write " + GNGEOGUI_CFG_FILE)
		else:
			ConfigFile.write("# Generated by gngeo-gui\n")
			ConfigFile.write("exec_path" + " " + ExecPath + "\n")
			ConfigFile.close()

	if buttons != "":
		tot_sleutel=""
		for sleutel in buttons:
			tot_sleutel = tot_sleutel + sleutel + ","
		tot_sleutel = tot_sleutel[:-1]
		self.options["p1key"] = tot_sleutel

        orgConfigFile = open(GNGEO_CFG_FILE,"r")
	try:
	        copyFile = open(GNGEO_CFG_FILE + ".old" ,"w")
	except:
		QMessageBox.critical(self, "Warning",  "Cannot write " + GNGEO_CFG_FILE + ".old")
	else:
		for line in orgConfigFile.readlines():
			copyFile.write(line)
		orgConfigFile.close()
		copyFile.close()
		try:
			newConfigFile = open(GNGEO_CFG_FILE,"w")
		except:
			QMessageBox.critical(self, "Warning",  "Cannot write " + GNGEO_CFG_FILE)
		else:
			newConfigFile.write("# Generated by gngeo-gui\n")
			for option in self.options:
				newConfigFile.write(option + " " + self.options[option] + "\n")
			newConfigFile.close()
			QMessageBox.critical(self, "success",  "configuration is saved")

    def listDefaultFirst(self, optVal,List):
	Position = List.index(self.options[optVal])
	List[Position], List[0] = List[0], List[Position]
	return List

    def on_keys_clicked(self):
        widget = keyWindow(self)
        widget.show()

    def on_paths_clicked(self):
        widget = pathWindow(self)
        widget.show()
	
class keyWindow(QDialog):
    def __init__(self, parent=None):
        super(keyWindow, self).__init__(parent)
        self.setWindowTitle("GnGeo-gui key config")
	# order : A,B,C,D,START,COIN,UP,DOWN,LEFT,RIGHT
	if buttons == "":
        	self.options = parse_config(self,GNGEO_CFG_FILE)
		self.P1Keys=self.options["p1key"].split(",")
	else:
		self.P1Keys = buttons
	Akey=self.P1Keys[0]
	Bkey=self.P1Keys[1]
	Ckey=self.P1Keys[2]
	Dkey=self.P1Keys[3]
	Startkey=self.P1Keys[4]
	Coinkey=self.P1Keys[5]
	Upkey=self.P1Keys[6]
	Downkey=self.P1Keys[7]
	Leftkey=self.P1Keys[8]
	Rightkey=self.P1Keys[9]
	area = QScrollArea(self)
	lay = QVBoxLayout(self)
	lay.addWidget(area)
	wg = QWidget()
	area.setWidget(wg)
	wg.setMinimumSize(600,900);
	grid = QGridLayout(wg)
	wg.show()
	area.show()
	grid.setColumnStretch(2, 20)
        font = QFont()
        font.setPointSize(24)
	# A-button
	self.AkeySpinBox = QDoubleSpinBox()
	self.AkeySpinBox.setRange(0, 300)
	self.AkeySpinBox.setValue(float(Akey))
	self.AkeySpinBox.setMinimumSize(150,60)
	self.AkeySpinBox.setDecimals(0)
	grid.addWidget(QLabel("A"), 1, 0 )
	grid.addWidget(self.AkeySpinBox, 1, 1)
	self.AButton = MyKeyPressed("pick A key",self)
	grid.addWidget(self.AButton, 1, 2)
	# B-button
	self.BkeySpinBox = QDoubleSpinBox()
	self.BkeySpinBox.setRange(1, 300)
	self.BkeySpinBox.setValue(float(Bkey))
	self.BkeySpinBox.setDecimals(0)
	grid.addWidget(QLabel("B"), 2, 0)
	grid.addWidget(self.BkeySpinBox, 2, 1)
	self.BButton = MyKeyPressed("pick B key",self)
	grid.addWidget(self.BButton, 2, 2)
	# C-button
	self.CkeySpinBox = QDoubleSpinBox()
	self.CkeySpinBox.setRange(1, 300)
	self.CkeySpinBox.setValue(float(Ckey))
	self.CkeySpinBox.setDecimals(0)
	grid.addWidget(QLabel("C"), 3, 0)
	grid.addWidget(self.CkeySpinBox, 3, 1)
	self.CButton = MyKeyPressed("pick C key",self)
	grid.addWidget(self.CButton, 3, 2)
	# D-button
	self.DkeySpinBox = QDoubleSpinBox()
	self.DkeySpinBox.setRange(0, 300)
	self.DkeySpinBox.setValue(float(Dkey))
	self.DkeySpinBox.setDecimals(0)
	grid.addWidget(QLabel("D"), 4, 0)
	grid.addWidget(self.DkeySpinBox, 4, 1)
	self.DButton = MyKeyPressed("pick D key",self)
	grid.addWidget(self.DButton, 4, 2)
	# Start-button
	self.StartkeySpinBox = QDoubleSpinBox()
	self.StartkeySpinBox.setRange(0, 300)
	self.StartkeySpinBox.setValue(float(Startkey))
	self.StartkeySpinBox.setDecimals(0)
	grid.addWidget(QLabel("START"), 5, 0)
	grid.addWidget(self.StartkeySpinBox, 5, 1)
	self.StartButton = MyKeyPressed("pick START key",self)
	grid.addWidget(self.StartButton, 5, 2)
	# Coin-button
	self.CoinkeySpinBox = QDoubleSpinBox()
	self.CoinkeySpinBox.setRange(0, 300)
	self.CoinkeySpinBox.setValue(float(Coinkey))
	self.CoinkeySpinBox.setDecimals(0)
	grid.addWidget(QLabel("COIN"), 6, 0)
	grid.addWidget(self.CoinkeySpinBox, 6, 1)
	self.CoinButton = MyKeyPressed("pick COIN key",self)
	grid.addWidget(self.CoinButton, 6, 2)
	# Up-key
	self.UpkeySpinBox = QDoubleSpinBox()
	self.UpkeySpinBox.setRange(0, 300)
	self.UpkeySpinBox.setValue(float(Upkey))
	self.UpkeySpinBox.setDecimals(0)
	grid.addWidget(QLabel("UP"), 7, 0)
	grid.addWidget(self.UpkeySpinBox, 7, 1)
	self.UpButton = MyKeyPressed("pick UP key",self)
	grid.addWidget(self.UpButton, 7, 2)
	# Down-key
	self.DownkeySpinBox = QDoubleSpinBox()
	self.DownkeySpinBox.setRange(0, 300)
	self.DownkeySpinBox.setValue(float(Downkey))
	self.DownkeySpinBox.setDecimals(0)
	grid.addWidget(QLabel("DOWN"), 8, 0)
	grid.addWidget(self.DownkeySpinBox, 8, 1)
	self.DownButton = MyKeyPressed("pick DOWN key",self)
	grid.addWidget(self.DownButton, 8, 2)
	# Left-key
	self.LeftkeySpinBox = QDoubleSpinBox()
	self.LeftkeySpinBox.setRange(0, 300)
	self.LeftkeySpinBox.setValue(float(Leftkey))
	self.LeftkeySpinBox.setDecimals(0)
	grid.addWidget(QLabel("LEFT"), 9, 0)
	grid.addWidget(self.LeftkeySpinBox, 9, 1)
	self.LeftButton = MyKeyPressed("pick LEFT key",self)
	grid.addWidget(self.LeftButton, 9, 2)
	# Right-key
	self.RightkeySpinBox = QDoubleSpinBox()
	self.RightkeySpinBox.setRange(0, 307)
	self.RightkeySpinBox.setValue(float(Rightkey))
	self.RightkeySpinBox.setDecimals(0)
	grid.addWidget(QLabel("RIGHT"), 10, 0)
	grid.addWidget(self.RightkeySpinBox, 10, 1)
	self.RightButton = MyKeyPressed("pick RIGHT key",self)
	grid.addWidget(self.RightButton, 10, 2)

	self.setLayout(grid)
	self.connect(self.AkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.BkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.CkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.DkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.StartkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.CoinkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.UpkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.DownkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.LeftkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.RightkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.RightButton, SIGNAL("keyPressed"),self.updateRight)
        self.connect(self.LeftButton, SIGNAL("keyPressed"),self.updateLeft)
        self.connect(self.DownButton, SIGNAL("keyPressed"),self.updateDown)
        self.connect(self.UpButton, SIGNAL("keyPressed"),self.updateUp)
        self.connect(self.CoinButton, SIGNAL("keyPressed"),self.updateCoin)
        self.connect(self.StartButton, SIGNAL("keyPressed"),self.updateStart)
        self.connect(self.AButton, SIGNAL("keyPressed"),self.updateA)
        self.connect(self.BButton, SIGNAL("keyPressed"),self.updateB)
        self.connect(self.CButton, SIGNAL("keyPressed"),self.updateC)
        self.connect(self.DButton, SIGNAL("keyPressed"),self.updateD)

    def updateRight(self):
	self.RightkeySpinBox.setValue(float(AsciiVal))
		
    def updateLeft(self):
	self.LeftkeySpinBox.setValue(float(AsciiVal))

    def updateUp(self):
	self.UpkeySpinBox.setValue(float(AsciiVal))

    def updateDown(self):
	self.DownkeySpinBox.setValue(float(AsciiVal))

    def updateStart(self):
	self.StartkeySpinBox.setValue(float(AsciiVal))

    def updateCoin(self):
	self.CoinkeySpinBox.setValue(float(AsciiVal))

    def updateA(self):
	self.AkeySpinBox.setValue(float(AsciiVal))

    def updateB(self):
	self.BkeySpinBox.setValue(float(AsciiVal))

    def updateC(self):
	self.CkeySpinBox.setValue(float(AsciiVal))

    def updateD(self):
	self.DkeySpinBox.setValue(float(AsciiVal))

    def change_value(self,event):
	self.P1Keys[0] = "%.0f" % self.AkeySpinBox.value()
	self.P1Keys[1] = "%.0f" % self.BkeySpinBox.value()
	self.P1Keys[2] = "%.0f" % self.CkeySpinBox.value()
	self.P1Keys[3] = "%.0f" % self.DkeySpinBox.value()
	self.P1Keys[4] = "%.0f" % self.StartkeySpinBox.value()
	self.P1Keys[5] = "%.0f" % self.CoinkeySpinBox.value()
	self.P1Keys[6] = "%.0f" % self.UpkeySpinBox.value()
	self.P1Keys[7] = "%.0f" % self.DownkeySpinBox.value()
	self.P1Keys[8] = "%.0f" % self.LeftkeySpinBox.value()
	self.P1Keys[9] = "%.0f" % self.RightkeySpinBox.value()
	global buttons
	buttons = self.P1Keys


class MyKeyPressed(QPushButton):
    def __init__(self, *args):
        QPushButton.__init__(self, *args)

    def event(self, event):
        if (event.type()==QEvent.KeyPress):
            # we have to get the SDL keysym
            #print event.key()
	    global AsciiVal
            if (event.key() < 256):
                AsciiVal = ord(str.lower(chr(event.key())))
            if (event.key() == 16777236):
		# right
                AsciiVal = 275;
	    if (event.key() == 16777234):
                # left
                AsciiVal = 276;
            if (event.key() == 16777235):
                # up
                AsciiVal = 273;
            if (event.key() == 16777237):
                # down
                AsciiVal = 274;
            if (event.key() == 16777219):
                # BS
                AsciiVal = 8;
            if (event.key() == 16777221):
                # Return
                AsciiVal = 13;
            if (event.key() == 16777248):
                # R-Shift
                AsciiVal = 303;
            if (event.key() == 16777249):
                # R-Control
                AsciiVal = 305;
            if (event.key() == 16781571):
                # R-Alt
                AsciiVal = 307;
            self.emit(SIGNAL("keyPressed"))
            #return True

        return QPushButton.event(self, event)


class pathWindow(QDialog):
    def __init__(self, parent=None):
        super(pathWindow, self).__init__(parent)
        self.setWindowTitle("GnGeo-gui path configuration")
        self.options = parse_config(self,GNGEO_CFG_FILE)
        self.gui_opts = parse_config(self,GNGEOGUI_CFG_FILE)
	if BiosPath == "":
		self.biosPath=self.options["biospath"]
	else:
		self.biosPath=BiosPath
	if RomrcPath == "":
		self.romrcPath=self.options["romrcdir"]
	else:
		self.romrcPath=RomrcPath
	if RomPath == "":
		self.romPath=self.options["rompath"]
	else:
		self.romPath=RomPath
	if ExecPath == "":
		self.execPath = self.gui_opts["exec_path"]
	else:
		self.execPath = ExecPath
	area = QScrollArea(self)
	lay = QVBoxLayout(self)
	lay.addWidget(area)
	wg = QWidget()
	area.setWidget(wg)
	wg.setMinimumSize(700,380);
	grid = QGridLayout(wg)
	wg.show()
	area.show()
	grid.setColumnStretch(1, 10)
	grid.setColumnStretch(2, 20)
	# bios path
        font = QFont()
        font.setPointSize(24)
        self.pushBiosButton = QPushButton(self.biosPath,self)
        self.pushBiosButton.setStyleSheet(
	"QPushButton { text-align: left; }")
	grid.addWidget(QLabel("BIOS"), 1, 0 )
	grid.addWidget(self.pushBiosButton, 1, 1)
	# romrc path
	self.pushRomrcButton = QPushButton(self.romrcPath,self)
        self.pushRomrcButton.setStyleSheet(
	"QPushButton { text-align: left; }")
	grid.addWidget(QLabel("romrc"), 2, 0)
	grid.addWidget(self.pushRomrcButton, 2, 1)
	# rom path
	self.pushRomButton = QPushButton(self.romPath,self)
        self.pushRomButton.setStyleSheet(
	"QPushButton { text-align: left; }")
	grid.addWidget(QLabel("roms"), 3, 0)
	grid.addWidget(self.pushRomButton, 3, 1)
	# exec path
	self.pushExecButton = QPushButton(self.execPath,self)
        self.pushExecButton.setStyleSheet(
	"QPushButton { text-align: left; }")
	grid.addWidget(QLabel("GnGeo"), 4, 0)
	grid.addWidget(self.pushExecButton, 4, 1)

	self.setLayout(grid)

	QObject.connect(self.pushBiosButton
		, SIGNAL("clicked()")
		, self.on_bios_button_clicked)
	QObject.connect(self.pushRomrcButton
		, SIGNAL("clicked()")
		, self.on_romrc_button_clicked)
	QObject.connect(self.pushRomButton
		, SIGNAL("clicked()")
		, self.on_rom_button_clicked)
	QObject.connect(self.pushExecButton
		, SIGNAL("clicked()")
		, self.on_exec_button_clicked)


    def on_bios_button_clicked(self):
	global BiosPath
	BiosPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home')
	if (not os.path.isfile(BiosPath + "/sfix.sfx")) and (BiosPath != "") :
		QMessageBox.critical(self, "Warning",  "Cannot find all bios files in " + BiosPath)
	self.close()

    def on_romrc_button_clicked(self):
	global RomrcPath
	RomrcPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home')
	if (not os.path.isfile(RomrcPath + "/kof96.rc")) and (RomrcPath != "") :
		QMessageBox.critical(self, "Warning",  "Cannot find " + RomrcPath + "/*.rc files")
	self.close()

    def on_rom_button_clicked(self):
	global RomPath
	RomPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home')
	self.close()

    def on_exec_button_clicked(self):
	global ExecPath
	ExecPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home/')
	if (not os.path.isfile(ExecPath + "/gngeo")) and (ExecPath != "") :
		QMessageBox.critical(self, "Warning",  "Cannot find " + ExecPath + "/gngeo")
	self.close()

if __name__ == "__main__":
    app = QApplication(sys.argv)
    ui = Ui_MainWindow()
    ui.show()
    sys.exit(app.exec_())

