// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_APPINFO_H
#define _GIOMM_APPINFO_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef GLIBMM_EXCEPTIONS_ENABLED
#include <exception>
#endif

#include <string>

#include <glibmm/interface.h>
#include <glibmm/object.h>
//#include <giomm/file.h>
#include <giomm/icon.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GAppInfoIface GAppInfoIface;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GAppLaunchContext GAppLaunchContext;
typedef struct _GAppLaunchContextClass GAppLaunchContextClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class AppLaunchContext_Class; } // namespace Gio
#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GAppInfo GAppInfo;
typedef struct _GAppInfoClass GAppInfoClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class AppInfo_Class; } // namespace Gio
namespace Gio
{

/** @addtogroup giommEnums Enums and Flags */

/**
 * @ingroup giommEnums
 * @par Bitwise operators:
 * <tt>%AppInfoCreateFlags operator|(AppInfoCreateFlags, AppInfoCreateFlags)</tt><br>
 * <tt>%AppInfoCreateFlags operator&(AppInfoCreateFlags, AppInfoCreateFlags)</tt><br>
 * <tt>%AppInfoCreateFlags operator^(AppInfoCreateFlags, AppInfoCreateFlags)</tt><br>
 * <tt>%AppInfoCreateFlags operator~(AppInfoCreateFlags)</tt><br>
 * <tt>%AppInfoCreateFlags& operator|=(AppInfoCreateFlags&, AppInfoCreateFlags)</tt><br>
 * <tt>%AppInfoCreateFlags& operator&=(AppInfoCreateFlags&, AppInfoCreateFlags)</tt><br>
 * <tt>%AppInfoCreateFlags& operator^=(AppInfoCreateFlags&, AppInfoCreateFlags)</tt><br>
 */
enum AppInfoCreateFlags
{
  APP_INFO_CREATE_NONE = 0,
  APP_INFO_CREATE_NEEDS_TERMINAL = 1 << 0,
  APP_INFO_CREATE_SUPPORTS_URIS = 1 << 1
};

/** @ingroup giommEnums */
inline AppInfoCreateFlags operator|(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)
  { return static_cast<AppInfoCreateFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline AppInfoCreateFlags operator&(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)
  { return static_cast<AppInfoCreateFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline AppInfoCreateFlags operator^(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)
  { return static_cast<AppInfoCreateFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline AppInfoCreateFlags operator~(AppInfoCreateFlags flags)
  { return static_cast<AppInfoCreateFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup giommEnums */
inline AppInfoCreateFlags& operator|=(AppInfoCreateFlags& lhs, AppInfoCreateFlags rhs)
  { return (lhs = static_cast<AppInfoCreateFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline AppInfoCreateFlags& operator&=(AppInfoCreateFlags& lhs, AppInfoCreateFlags rhs)
  { return (lhs = static_cast<AppInfoCreateFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline AppInfoCreateFlags& operator^=(AppInfoCreateFlags& lhs, AppInfoCreateFlags rhs)
  { return (lhs = static_cast<AppInfoCreateFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


class AppInfo;
class File;

/** This is used to handle, for instance, startup notification and launching of the new application on the same screen as the launching window.
 * See also AppInfo.
 *
 * @newin{2,16}
 */

class AppLaunchContext : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef AppLaunchContext CppObjectType;
  typedef AppLaunchContext_Class CppClassType;
  typedef GAppLaunchContext BaseObjectType;
  typedef GAppLaunchContextClass BaseClassType;

private:  friend class AppLaunchContext_Class;
  static CppClassType applaunchcontext_class_;

private:
  // noncopyable
  AppLaunchContext(const AppLaunchContext&);
  AppLaunchContext& operator=(const AppLaunchContext&);

protected:
  explicit AppLaunchContext(const Glib::ConstructParams& construct_params);
  explicit AppLaunchContext(GAppLaunchContext* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~AppLaunchContext();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GAppLaunchContext*       gobj()       { return reinterpret_cast<GAppLaunchContext*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GAppLaunchContext* gobj() const { return reinterpret_cast<GAppLaunchContext*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GAppLaunchContext* gobj_copy();

private:


protected:
  AppLaunchContext();

public:
  
  static Glib::RefPtr<AppLaunchContext> create();


  /** Gets the display string for the display. This is used to ensure new
   * applications are started on the same display as the launching 
   * application.
   * @param info A AppInfo.
   * @param files A List of File objects.
   * @return A display string for the display.
   */
  std::string get_display(const Glib::RefPtr<AppInfo>& info, const Glib::ListHandle< Glib::RefPtr<Gio::File> >& files);

  
  /** Initiates startup notification for the application and returns the
   * DESKTOP_STARTUP_ID for the launched operation, if supported.
   * 
   * Startup notification IDs are defined in the 
   * FreeDesktop.Org Startup Notifications standard.
   * @param info A AppInfo.
   * @param files A List of of File objects.
   * @return A startup notification ID for the application, or <tt>0</tt> if 
   * not supported.
   */
  std::string get_startup_notify_id(const Glib::RefPtr<AppInfo>& info, const Glib::ListHandle< Glib::RefPtr<Gio::File> >& files);
  
  /** Called when an application has failed to launch, so that it can cancel
   * the application startup notification started in g_app_launch_context_get_startup_notify_id().
   * @param startup_notify_id The startup notification id that was returned by g_app_launch_context_get_startup_notify_id().
   */
  void launch_failed(const std::string& startup_notify_id);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

/** Application information, to describe applications installed on the system, 
 * and launch them.
 * See also AppLaunchContext.
 *
 * @newin{2,16}
 */

class AppInfo : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef AppInfo CppObjectType;
  typedef AppInfo_Class CppClassType;
  typedef GAppInfo BaseObjectType;
  typedef GAppInfoIface BaseClassType;

private:
  friend class AppInfo_Class;
  static CppClassType appinfo_class_;

  // noncopyable
  AppInfo(const AppInfo&);
  AppInfo& operator=(const AppInfo&);

protected:
  AppInfo(); // you must derive from this class

  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit AppInfo(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit AppInfo(GAppInfo* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~AppInfo();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GAppInfo*       gobj()       { return reinterpret_cast<GAppInfo*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GAppInfo* gobj() const { return reinterpret_cast<GAppInfo*>(gobject_); }

private:


public:
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static Glib::RefPtr<AppInfo> create_from_commandline(const std::string& commandline,
                                                       const std::string& application_name,
                                                       AppInfoCreateFlags flags);
#else
  static Glib::RefPtr<AppInfo> create_from_commandline(const std::string& commandline,
                                                       const std::string& application_name,
                                                       AppInfoCreateFlags flags,
                                                       std::auto_ptr<Glib::Error>& error);
#endif // GLIBMM_EXCEPTIONS_ENABLED

  //__IGNORE(g_app_info_dup)
  

  // Note that the implementation of equal() is virtual via equal_vfunc().
  
  /** Checks if two AppInfos are equal.
   * @param appinfo2 The second AppInfo.
   * @return <tt>true</tt> if @a appinfo1 is equal to @a appinfo2. <tt>false</tt> otherwise.
   */
  bool equal(const Glib::RefPtr<AppInfo>& other) const;

  
  /** Gets the ID of an application. An id is a string that
   * identifies the application. The exact format of the id is
   * platform dependent. For instance, on Unix this is the
   * desktop file id from the xdg menu specification.
   * 
   * Note that the returned ID may be <tt>0</tt>, depending on how
   * the @a appinfo has been constructed.
   * @return A string containing the application's ID.
   */
  std::string get_id() const;
  
  /** Gets the installed name of the application.
   * @return The name of the application for @a appinfo.
   */
  std::string get_name() const;
  
  /** Gets a human-readable description of an installed application.
   * @return A string containing a description of the 
   * application @a appinfo, or <tt>0</tt> if none.
   */
  std::string get_description() const;
  
  /** Gets the executable's name for the installed application.
   * @return A string containing the @a appinfo's application 
   * binary's name.
   */
  std::string get_executable() const;
  
  /** Gets the commandline with which the application will be
   * started.
   * @return A string containing the @a appinfo's commandline, 
   * or <tt>0</tt> if this information is not available
   * 
   * @newin{2,20}.
   */
  std::string get_commandline() const;

  
  /** Gets the icon for the application.
   * @return The default Icon for @a appinfo.
   */
  Glib::RefPtr<Icon> get_icon();
  
  /** Gets the icon for the application.
   * @return The default Icon for @a appinfo.
   */
  const Glib::RefPtr<const Icon> get_icon() const;

  
  /** Launches the application. Passes @a files to the launched application 
   * as arguments, using the optional @a launch_context to get information
   * about the details of the launcher (like what screen it is on).
   * On error, @a error will be set accordingly.
   * 
   * To lauch the application without arguments pass a <tt>0</tt> @a files list.
   * 
   * Note that even if the launch is successful the application launched
   * can fail to start if it runs into problems during startup. There is
   * no way to detect this.
   * 
   * Some URIs can be changed when passed through a GFile (for instance
   * unsupported uris with strange formats like mailto:), so if you have
   * a textual uri you want to pass in as argument, consider using
   * g_app_info_launch_uris() instead.
   * @param files A List of File objects.
   * @param launch_context A AppLaunchContext or <tt>0</tt>.
   * @return <tt>true</tt> on successful launch, <tt>false</tt> otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool launch(const Glib::ListHandle<std::string>& files,
                           const Glib::RefPtr<AppLaunchContext>& launch_context);
#else
  bool launch(const Glib::ListHandle<std::string>& files, const Glib::RefPtr<AppLaunchContext>& launch_context, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Checks if the application supports reading files and directories from URIs.
   * @return <tt>true</tt> if the @a appinfo supports URIs.
   */
  bool supports_uris() const;
  
  /** Checks if the application accepts files as arguments.
   * @return <tt>true</tt> if the @a appinfo supports files.
   */
  bool supports_files() const;
  
  /** Launches the application. Passes @a uris to the launched application 
   * as arguments, using the optional @a launch_context to get information
   * about the details of the launcher (like what screen it is on).
   * On error, @a error will be set accordingly.
   * 
   * To lauch the application without arguments pass a <tt>0</tt> @a uris list.
   * 
   * Note that even if the launch is successful the application launched
   * can fail to start if it runs into problems during startup. There is
   * no way to detect this.
   * @param uris A List containing URIs to launch.
   * @param launch_context A AppLaunchContext or <tt>0</tt>.
   * @return <tt>true</tt> on successful launch, <tt>false</tt> otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool launch_uris(const Glib::ListHandle<std::string>& uris,
                                GAppLaunchContext* launch_context);
#else
  bool launch_uris(const Glib::ListHandle<std::string>& uris, GAppLaunchContext* launch_context, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Checks if the application info should be shown in menus that 
   * list available applications.
   * @return <tt>true</tt> if the @a appinfo should be shown, <tt>false</tt> otherwise.
   */
  bool should_show() const;
  // FIXME: use better terminology than delete/do_delete
  
  /** Obtains the information whether the GAppInfo can be deleted.
   * See g_app_info_delete().
   * @return <tt>true</tt> if @a appinfo can be deleted
   * 
   * @newin{2,20}.
   */
  bool can_delete() const;
  
  /** Tries to delete an AppInfo. 
   * 
   * On some platforms, there may be a difference between user-defined
   * AppInfo&lt;!-- --&gt;s which can be deleted, and system-wide ones which
   * cannot. See g_app_info_can_delete().
   * @return <tt>true</tt> if @a appinfo has been deleted
   * 
   * @newin{2,20}.
   */
  bool do_delete();

  
  /** Sets the application as the default handler for a given type.
   * @param content_type The content type.
   * @return <tt>true</tt> on success, <tt>false</tt> on error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool set_as_default_for_type(const std::string& content_type);
#else
  bool set_as_default_for_type(const std::string& content_type, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Sets the application as the default handler for the given file extention.
   * @param extension A string containing the file extension (without the dot).
   * @return <tt>true</tt> on success, <tt>false</tt> on error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool set_as_default_for_extension(const std::string& extension);
#else
  bool set_as_default_for_extension(const std::string& extension, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Adds a content type to the application information to indicate the 
   * application is capable of opening files with the given content type.
   * @param content_type A string.
   * @return <tt>true</tt> on success, <tt>false</tt> on error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool add_supports_type(const std::string& content_type);
#else
  bool add_supports_type(const std::string& content_type, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Checks if a supported content type can be removed from an application.
   * @return <tt>true</tt> if it is possible to remove supported 
   * content types from a given @a appinfo, <tt>false</tt> if not.
   */
  bool can_remove_supports_type() const;
  
  /** Removes a supported type from an application, if possible.
   * @param content_type A string.
   * @return <tt>true</tt> on success, <tt>false</tt> on error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool remove_supports_type(const std::string& content_type);
#else
  bool remove_supports_type(const std::string& content_type, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

 
  /** Gets a list of all of the applications currently registered 
   * on this system.
   * 
   * For desktop files, this includes applications that have 
   * <tt>NoDisplay=true</tt> set or are excluded from 
   * display by means of <tt>OnlyShowIn</tt> or
   * <tt>NotShowIn</tt>. See g_app_info_should_show().
   * The returned list does not include applications which have
   * the <tt>Hidden</tt> key set.
   * @return A newly allocated List of references to AppInfo&lt;!----&gt;s.
   */
  static Glib::ListHandle<Glib::RefPtr<AppInfo> > get_all();
  
  /** Gets a list of all AppInfo s for a given content type.
   * @param content_type The content type to find a AppInfo for.
   * @return List of AppInfo s for given @a content_type
   * or <tt>0</tt> on error.
   */
  static Glib::ListHandle<Glib::RefPtr<AppInfo> > get_all_for_type(const std::string& content_type);
  
  /** Gets the AppInfo that correspond to a given content type.
   * @param content_type The content type to find a AppInfo for.
   * @param must_support_uris If <tt>true</tt>, the AppInfo is expected to
   * support URIs.
   * @return AppInfo for given @a content_type or <tt>0</tt> on error.
   */
  static Glib::RefPtr<AppInfo> get_default_for_type(const std::string& content_type, bool must_support_uris = true);
  
  /** Gets the default application for launching applications 
   * using this URI scheme. A URI scheme is the initial part 
   * of the URI, up to but not including the ':', e.g. "http", 
   * "ftp" or "sip".
   * @param uri_scheme A string containing a URI scheme.
   * @return AppInfo for given @a uri_scheme or <tt>0</tt> on error.
   */
  static Glib::RefPtr<AppInfo> get_default_for_uri_scheme(const std::string& uri_scheme);
  
  /** Removes all changes to the type associations done by
   * g_app_info_set_as_default_for_type(), 
   * g_app_info_set_as_default_for_extension(), 
   * g_app_info_add_supports_type() of g_app_info_remove_supports_type().
   * 
   * @newin{2,20}
   * @param content_type A content type.
   */
  static void reset_type_associations(const std::string& content_type);
  
  /** Utility function that launches the default application 
   * registered to handle the specified uri. Synchronous I/O
   * is done on the uri to detect the type of the file if
   * required.
   * @param uri The uri to show.
   * @param launch_context An optional AppLaunchContext.
   * @return <tt>true</tt> on success, <tt>false</tt> on error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static bool launch_default_for_uri(const std::string& uri, const Glib::RefPtr<AppLaunchContext>& context);
#else
  static bool launch_default_for_uri(const std::string& uri, const Glib::RefPtr<AppLaunchContext>& context, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  // same as above but without optional AppLaunchContext
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static bool launch_default_for_uri(const std::string& uri);
#else
  static bool launch_default_for_uri(const std::string& uri, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

protected:
  //_WRAP_VFUNC(Glib::RefPtr<AppInfo> dup(), "dup")
  //_WRAP_VFUNC(bool equal(const Glib::RefPtr<AppInfo>& appinfo2), "equal")
  //_WRAP_VFUNC(std::string get_id() const, "get_id")
  //_WRAP_VFUNC(std::string get_name() const, "get_name")
  //_WRAP_VFUNC(std::string get_description() const, "get_description")
  //_WRAP_VFUNC(std::string get_executable() const, "get_executable")
  //_WRAP_VFUNC(Glib::RefPtr<Icon> get_icon() const, "get_icon")
 

  //_WRAP_VFUNC(bool launch(const Glib::ListHandle<std::string>& filenames, const Glib::RefPtr<AppLaunchContext>& launch_context, GError** error), "launch")
  //_WRAP_VFUNC(bool supports_uris() const, "supports_uris")
  //_WRAP_VFUNC(bool supports_files() const, "supports_files")
  //_WRAP_VFUNC(bool launch_uris(const Glib::ListHandle<std::string>& uris, const Glib::RefPtr<AppLaunchContext>& launch_context, GError** error), "launch_uris")
  //_WRAP_VFUNC(bool should_show() const, "should_show")
  //_WRAP_VFUNC(bool set_as_default_for_type(const std::string& content_type, GError** error), "set_as_default_for_type")
  //_WRAP_VFUNC(bool set_as_default_for_extension(const std::string& extension, GError** error), "set_as_default_for_extension")
  //_WRAP_VFUNC(bool add_supports_type(const std::string& content_type, GError** error), "add_supports_type")
  //_WRAP_VFUNC(bool can_remove_supports_type() const, "can_remove_supports_type")
  //_WRAP_VFUNC(bool remove_supports_type(const std::string& content_type, GError** error), "remove_supports_type")


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::AppLaunchContext
   */
  Glib::RefPtr<Gio::AppLaunchContext> wrap(GAppLaunchContext* object, bool take_copy = false);
}


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::AppInfo
   */
  Glib::RefPtr<Gio::AppInfo> wrap(GAppInfo* object, bool take_copy = false);

} // namespace Glib


#endif /* _GIOMM_APPINFO_H */

