/* appbar.h: statusbar/progress widget
 * 
 * Based on gnome-appbar by Havoc Pennington
 * Based on MozStatusbar widget, by Chris Toshok
 * In turn based on GtkStatusbar widget, from Gtk+,
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 * GtkStatusbar Copyright (C) 1998 Shawn T. Amundson
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 */

#if !defined(__APPBAR_H__)
# define __APPBAR_H__ (1)

#include <gtk/gtkhbox.h>
#include <gtk/gtkprogressbar.h>


G_BEGIN_DECLS

#define GJITEN_TYPE_APPBAR            (appbar_get_type())
#define GJITEN_APPBAR(obj)            (GTK_CHECK_CAST((obj), \
 GJITEN_TYPE_APPBAR,AppBar))
#define GJITEN_APPBAR_CLASS(klass)    (GTK_CHECK_CLASS_CAST((klass), \
 GJITEN_TYPE_APPBAR,AppBarClass))
#define GJITEN_IS_APPBAR(obj)         (GTK_CHECK_TYPE((obj), \
 GJITEN_TYPE_APPBAR))
#define GJITEN_IS_APPBAR_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), \
 GJITEN_TYPE_APPBAR))
#define GJITEN_APPBAR_GET_CLASS(obj)  (GTK_CHECK_GET_CLASS((obj), \
 GJITEN_TYPE_APPBAR,AppBarClass))


typedef struct AppBar        AppBar;
typedef struct AppBarPrivate AppBarPrivate;
typedef struct AppBarClass   AppBarClass;
typedef struct AppBarMsg     AppBarMsg;

struct AppBar{
  GtkHBox        parent_widget;
  AppBarPrivate *priv;
};

struct AppBarClass{
  GtkHBoxClass parent_class;
};

GType appbar_get_type(void)G_GNUC_CONST;

GtkWidget *appbar_new(gboolean _has_progress,gboolean _has_status);

/*Sets the status label without changing widget state; next set or push will
   destroy this permanently.*/
void appbar_set_status(AppBar *_appbar,const gchar *_status);
/*Get the statusbar.*/
GtkWidget *appbar_get_status(AppBar *_appbar);
/*What to show when showing nothing else; defaults to nothing.*/
void appbar_set_default(AppBar *_appbar,const gchar *_default_status);
void appbar_push(AppBar *_appbar,const gchar *_status);
/*OK to call on empty stack.*/
void appbar_pop(AppBar *_appbar);
void appbar_clear_stack(AppBar *_appbar);
/*Sugar function to set the percentage of the progressbar.*/
void appbar_set_progress_percentage(AppBar *_appbar,gfloat _percentage);
GtkProgressBar *appbar_get_progress(AppBar *_appbar);
/*Reflect the current state of stack/default.
  Useful to force a set_status to disappear.*/
void appbar_refresh(AppBar *_appbar);

G_END_DECLS

#endif
