#ifndef GAMEAREA_H
#define GAMEAREA_H

/*
  This file is part of "GiveMeFive" - A simple "five in a row" game.
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Base/Model.h>

#include <vector>

class GameArea : public Lum::Base::Model
{
public:
  static const size_t dimension=19;

  enum Value {
    empty,
    player1,
    player2
  };

  enum State {
    stateHuman,
    stateComputer,
    stateFinished
  };

  class Point
  {
  public:
    size_t x;
    size_t y;
    Value  value;

  public:
    Point();
    Point(size_t x, size_t y, Value value);
  };

  typedef std::vector<std::vector<Point> > Linearisation;

  class Rule
  {
  public:
    virtual ~Rule();

    virtual bool Check(GameArea& area,
                       const Linearisation& linearisation,
                       Point& move) = 0;
  };

  class Rule1D : public Rule
  {
  private:
    std::wstring pattern;

  public:
    Rule1D(const std::wstring& pattern);
    bool Check(GameArea& area,
               const Linearisation& linearisation,
               Point& move);
  };

private:
  Value            area[dimension*dimension];
  bool             marked[dimension*dimension];
  State            state;
  std::list<Rule*> rules;

public:
  GameArea();
  ~GameArea();

  void RestartGame();

  bool IsSet(size_t x, size_t y) const;
  void Set(size_t x, size_t y, Value value);
  Value Get(size_t x, size_t y) const;

  bool IsMarked(size_t x, size_t y) const;
  void SetMark(size_t x, size_t y);

  State GetState() const;

  Value GetCurrentPlayer() const;
  Value GetOtherPlayer() const;

  void PlayerFinished();

  void GetLinearisation(Linearisation& linearisation) const;

  bool CheckFinished(const Linearisation& linearisation);

  void CalculateNextMove(const Linearisation& linearisation);
};

typedef Lum::Base::Reference<GameArea> GameAreaRef;

#endif
