/*****************************************************************************
 * Copyright: 2010-2011 Christian Fetzer <fetzer.ch@googlemail.com>          *
 * Copyright: 2010-2011 Michael Zanetti <mzanetti@kde.org>                   *
 *                                                                           *
 * This program is free software: you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation, either version 3 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.     *
 *                                                                           *
 ****************************************************************************/

#include <QApplication>
#include <QTranslator>
#include <QLocale>
#include <QLibraryInfo>
#include <QDebug>
#include <QNetworkProxy>
#include <QtPlugin>
#include "networkapplication.h"
#include "core.h"
#include "mainwindow.h"

#ifndef Q_OS_SYMBIAN
// Re-enable this once the plugins compile and link successfully on symbian
Q_IMPORT_PLUGIN(qtgeoservices_osm)
#endif

int main(int argc, char *argv[]) {
    //Q_INIT_RESOURCE(getmewheels);

    NetworkApplication app(argc, argv);
    app.setOrganizationName("");
    app.setApplicationName("Get Me Wheels");

    QTranslator qtTranslator;
    qtTranslator.load("qt_" + QLocale::system().name(), QLibraryInfo::location(QLibraryInfo::TranslationsPath));
    app.installTranslator(&qtTranslator);

    QTranslator myappTranslator;
    myappTranslator.load("getmewheels", "/usr/share/locale/" + QLocale::system().name() + "/getmewheels");
    app.installTranslator(&myappTranslator);

    qDebug() << "installing translator for:" << "/usr/share/locale/" + QLocale::system().name() + "/getmewheels";

    Core::init();

    return app.exec();
}
