/*****************************************************************************
 * Copyright: 2010-2011 Christian Fetzer <fetzer.ch@googlemail.com>          *
 * Copyright: 2010-2011 Michael Zanetti <mzanetti@kde.org>                   *
 *                                                                           *
 * This program is free software: you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation, either version 3 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.     *
 *                                                                           *
 ****************************************************************************/

#ifndef ITEMDIALOG_H
#define ITEMDIALOG_H

#include <data/gmwvehicle.h>

#include <QDialog>
#include <QMap>
#include <QGeoPositionInfo>

class QStackedWidget;
class QPushButton;
class QBoxLayout;
class QLayout;
class QLabel;

class ItemDialog : public QDialog
{
    Q_OBJECT

public:
    explicit ItemDialog(QWidget *parent = 0, Qt::WindowFlags f = 0);
    ~ItemDialog();
    void addObject(GMWItem *object);

signals:
    void zoomTo(const QGeoCoordinate &coordinate);

public slots:
    void nextPage();
    void previousPage();
    void goToPage(int page);
    void currentPositionChanged();

private:
    QStackedWidget *m_stackWidget;
    QPushButton *m_pbNext;
    QPushButton *m_pbGoTo;
    QPushButton *m_pbPrevious;
    QMap<int, GMWItem*> m_objectMap;
    QMap<GMWItem*, QLabel*> m_distanceLabelMap;
    QMap<GMWItem*, QLabel*> m_azimuthLabelMap;
    QBoxLayout *m_masterLayout;
    QBoxLayout *m_buttonLayout;

    QString smileyName(GMWVehicle::State state);
    QString statusText(GMWVehicle::State state);
    QWidget *createPage(GMWItem *object);
    void updateWindowTitle(GMWItem *object);

private slots:
    void slotGoTo();
};

#endif // ITEMDIALOG_H
