/*****************************************************************************
 * Copyright: 2010-2011 Christian Fetzer <fetzer.ch@googlemail.com>          *
 * Copyright: 2010-2011 Michael Zanetti <mzanetti@kde.org>                   *
 *                                                                           *
 * This program is free software: you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation, either version 3 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.     *
 *                                                                           *
 ****************************************************************************/

#ifndef CAR2GOENGINE_H
#define CAR2GOENGINE_H

#include "engines/gmwengine.h"

#include <QtCore/QList>

#include <QtNetwork/QNetworkAccessManager>
#include <QtNetwork/QNetworkReply>

class Car2goEngine : public GMWEngine
{
    Q_OBJECT

public:
    // See http://code.google.com/p/car2go/wiki/OpenAPIv20r10Locations
    Car2goEngine(const QString &cacheDir);

    QStringList supportedLocations();

    QGeoBoundingBox startingBounds();

    GMWBusinessArea businessArea();

public slots:
    void refreshStationary(bool useCache = true);
    void refreshVehicles(bool useCache = true);

private:
    enum NetworkReplyType {IconReply, GasStationReply, VehiclesReply, ParkingSpotsReply};
    QString m_cacheDir;

    QNetworkAccessManager m_network;

    QNetworkReply* m_networkReplyParkingSpots;
    QNetworkReply* m_networkReplyGasStations;
    QNetworkReply* m_networkReplyVehicles;
    QNetworkReply* m_networkReplyParkingSpotsImage;
    QNetworkReply* m_networkReplyGasStationsImage;
    QNetworkReply* m_networkReplyVehiclesImage;

    QList<QNetworkReply*> m_downloads;

    QString m_xmlParkingSpots;
    QString m_xmlGasStations;
    QString m_xmlVehicles;

    QPixmap m_imageParkingSpots;
    QPixmap m_imageGasStations;
    QPixmap m_imageVehicles;

    QTime m_stats;

    GMWBusinessArea m_businessArea;

    void parseImage(NetworkReplyType type, const QString &xml);
    void parse(NetworkReplyType type, const QString &xml);
    bool hasDownloadError() const;

    void refreshGasStations(bool useCache);
    void refreshParkingSpots(bool useCache);

private slots:
    void receivedData(QNetworkReply *reply);
    void loadBusinessArea();
};

#endif // CAR2GOENGINE_H
