/*****************************************************************************
 * Copyright: 2010-2011 Christian Fetzer <fetzer.ch@googlemail.com>          *
 * Copyright: 2010-2011 Michael Zanetti <mzanetti@kde.org>                   *
 *                                                                           *
 * This program is free software: you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation, either version 3 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.     *
 *                                                                           *
 ****************************************************************************/

#include "navigator.h"

#include <QtCore/QDebug>

Navigator::Navigator(QGeoRoutingManager *routingManager, MobilityMap *mapWidget, const QGeoCoordinate &destination) :
    m_routingManager(routingManager),
    m_mapWidget(mapWidget)
{
    QList<QGeoCoordinate> waypoints;
    waypoints.append(destination);
    m_request.setWaypoints(waypoints);
}

Navigator::~Navigator()
{
}

void Navigator::start()
{
    QList<QGeoCoordinate> waypoints = m_request.waypoints();
    waypoints.prepend(QGeoCoordinate(48,10));
    m_request.setWaypoints(waypoints);

    m_reply = m_routingManager->calculateRoute(m_request);
    if (m_reply->isFinished()) {
        routingFinished();
    } else {
        connect(m_reply, SIGNAL(error(QGeoRouteReply::Error,QString)), SLOT(routingError(QGeoRouteReply::Error,QString)));
        connect(m_reply, SIGNAL(finished()), SLOT(routingFinished()));
    }

//    startMarker = new Marker(Marker::StartMarker);
//    startMarker->setCoordinate(mapsWidget->markerManager()->myLocation());
//    startMarker->setName("Start point");
//    mapsWidget->map()->addMapObject(startMarker);

//    endMarker = new Marker(Marker::EndMarker);
//    endMarker->setCoordinate(place.coordinate());
//    endMarker->setAddress(place.address());
//    endMarker->setName("Destination");
//    mapsWidget->map()->addMapObject(endMarker);
}

void Navigator::routingFinished()
{
    if (m_reply->routes().size() <= 0) {
        routingError(QGeoRouteReply::NoError, "No valid routes returned");
        m_reply->deleteLater();
        return;
    }

    QGeoRoute route = m_reply->routes().at(0);
    m_firstRoute = route;

    m_routeObject = new QGeoMapRouteObject;
    m_routeObject->setRoute(route);
    m_routeObject->setPen(QPen(Qt::blue, 2.0));

    //m_mapWidget->geoMap()->addMapObject(m_routeObject);

    emit finished();
    m_reply->deleteLater();
}

void Navigator::routingError(QGeoRouteReply::Error err, QString errorString)
{
    qDebug() << "Routing error:" << errorString;
    emit error(err, errorString);
}
