#ifndef USBMANAGER_H
#define USBMANAGER_H

#include <QMainWindow>

namespace Ui {
class UsbManager;
}
class ProcessRunner;

class UsbManager : public QMainWindow
{
    Q_OBJECT
    
public:
    explicit UsbManager(QWidget *parent = 0);
    ~UsbManager();

public slots:
    void dataAvailable(int exitCode);
    void load_g_ether(void);
    void load_g_nokia(void);
    void load_g_file_storage(void);
    void refresh();

signals:
    void done(int ec);

private slots:
    void on_pushButton_usbmwin_clicked();

    void on_pushButton_usbmlin_clicked();

    void on_pushButton_usbmstor_clicked();

private:
    Ui::UsbManager *ui;
    ProcessRunner *m_runner;
        bool m_conf_usb_iface;
};

#endif // USBMANAGER_H
