/*
 * Bink video decoder
 * Copyright (C) 2009 Kostya Shishkov
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef AVCODEC_BINKDATA_H
#define AVCODEC_BINKDATA_H

/** Bink DCT and residue 8x8 block scan order */
static const uint8_t bink_scan[64] = {
     0,  1,  8,  9,  2,  3, 10, 11,
     4,  5, 12, 13,  6,  7, 14, 15,
    20, 21, 28, 29, 22, 23, 30, 31,
    16, 17, 24, 25, 32, 33, 40, 41,
    34, 35, 42, 43, 48, 49, 56, 57,
    50, 51, 58, 59, 18, 19, 26, 27,
    36, 37, 44, 45, 38, 39, 46, 47,
    52, 53, 60, 61, 54, 55, 62, 63
};

static const uint8_t bink_tree_bits[16][16] = {
    {
        0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
        0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
    },
    {
        0x00, 0x01, 0x03, 0x05, 0x07, 0x09, 0x0B, 0x0D,
        0x0F, 0x13, 0x15, 0x17, 0x19, 0x1B, 0x1D, 0x1F,
    },
    {
        0x00, 0x02, 0x01, 0x09, 0x05, 0x15, 0x0D, 0x1D,
        0x03, 0x13, 0x0B, 0x1B, 0x07, 0x17, 0x0F, 0x1F,
    },
    {
        0x00, 0x02, 0x06, 0x01, 0x09, 0x05, 0x0D, 0x1D,
        0x03, 0x13, 0x0B, 0x1B, 0x07, 0x17, 0x0F, 0x1F,
    },
    {
        0x00, 0x04, 0x02, 0x06, 0x01, 0x09, 0x05, 0x0D,
        0x03, 0x13, 0x0B, 0x1B, 0x07, 0x17, 0x0F, 0x1F,
    },
    {
        0x00, 0x04, 0x02, 0x0A, 0x06, 0x0E, 0x01, 0x09,
        0x05, 0x0D, 0x03, 0x0B, 0x07, 0x17, 0x0F, 0x1F,
    },
    {
        0x00, 0x02, 0x0A, 0x06, 0x0E, 0x01, 0x09, 0x05,
        0x0D, 0x03, 0x0B, 0x1B, 0x07, 0x17, 0x0F, 0x1F,
    },
    {
        0x00, 0x01, 0x05, 0x03, 0x13, 0x0B, 0x1B, 0x3B,
        0x07, 0x27, 0x17, 0x37, 0x0F, 0x2F, 0x1F, 0x3F,
    },
    {
        0x00, 0x01, 0x03, 0x13, 0x0B, 0x2B, 0x1B, 0x3B,
        0x07, 0x27, 0x17, 0x37, 0x0F, 0x2F, 0x1F, 0x3F,
    },
    {
        0x00, 0x01, 0x05, 0x0D, 0x03, 0x13, 0x0B, 0x1B,
        0x07, 0x27, 0x17, 0x37, 0x0F, 0x2F, 0x1F, 0x3F,
    },
    {
        0x00, 0x02, 0x01, 0x05, 0x0D, 0x03, 0x13, 0x0B,
        0x1B, 0x07, 0x17, 0x37, 0x0F, 0x2F, 0x1F, 0x3F,
    },
    {
        0x00, 0x01, 0x09, 0x05, 0x0D, 0x03, 0x13, 0x0B,
        0x1B, 0x07, 0x17, 0x37, 0x0F, 0x2F, 0x1F, 0x3F,
    },
    {
        0x00, 0x02, 0x01, 0x03, 0x13, 0x0B, 0x1B, 0x3B,
        0x07, 0x27, 0x17, 0x37, 0x0F, 0x2F, 0x1F, 0x3F,
    },
    {
        0x00, 0x01, 0x05, 0x03, 0x07, 0x27, 0x17, 0x37,
        0x0F, 0x4F, 0x2F, 0x6F, 0x1F, 0x5F, 0x3F, 0x7F,
    },
    {
        0x00, 0x01, 0x05, 0x03, 0x07, 0x17, 0x37, 0x77,
        0x0F, 0x4F, 0x2F, 0x6F, 0x1F, 0x5F, 0x3F, 0x7F,
    },
    {
        0x00, 0x02, 0x01, 0x05, 0x03, 0x07, 0x27, 0x17,
        0x37, 0x0F, 0x2F, 0x6F, 0x1F, 0x5F, 0x3F, 0x7F,
    },
};

static const uint8_t bink_tree_lens[16][16] = {
    { 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4 },
    { 1, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5 },
    { 2, 2, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5 },
    { 2, 3, 3, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5 },
    { 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5 },
    { 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5 },
    { 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5 },
    { 1, 3, 3, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6 },
    { 1, 2, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6 },
    { 1, 3, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6 },
    { 2, 2, 3, 4, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6 },
    { 1, 4, 4, 4, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6 },
    { 2, 2, 2, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6 },
    { 1, 3, 3, 3, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7 },
    { 1, 3, 3, 3, 5, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7 },
    { 2, 2, 3, 3, 3, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7 },
};

static const uint8_t bink_patterns[16][64] = {
    {
        0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x38,
        0x39, 0x31, 0x29, 0x21, 0x19, 0x11, 0x09, 0x01,
        0x02, 0x0A, 0x12, 0x1A, 0x22, 0x2A, 0x32, 0x3A,
        0x3B, 0x33, 0x2B, 0x23, 0x1B, 0x13, 0x0B, 0x03,
        0x04, 0x0C, 0x14, 0x1C, 0x24, 0x2C, 0x34, 0x3C,
        0x3D, 0x35, 0x2D, 0x25, 0x1D, 0x15, 0x0D, 0x05,
        0x06, 0x0E, 0x16, 0x1E, 0x26, 0x2E, 0x36, 0x3E,
        0x3F, 0x37, 0x2F, 0x27, 0x1F, 0x17, 0x0F, 0x07,
    },
    {
        0x3B, 0x3A, 0x39, 0x38, 0x30, 0x31, 0x32, 0x33,
        0x2B, 0x2A, 0x29, 0x28, 0x20, 0x21, 0x22, 0x23,
        0x1B, 0x1A, 0x19, 0x18, 0x10, 0x11, 0x12, 0x13,
        0x0B, 0x0A, 0x09, 0x08, 0x00, 0x01, 0x02, 0x03,
        0x04, 0x05, 0x06, 0x07, 0x0F, 0x0E, 0x0D, 0x0C,
        0x14, 0x15, 0x16, 0x17, 0x1F, 0x1E, 0x1D, 0x1C,
        0x24, 0x25, 0x26, 0x27, 0x2F, 0x2E, 0x2D, 0x2C,
        0x34, 0x35, 0x36, 0x37, 0x3F, 0x3E, 0x3D, 0x3C,
    },
    {
        0x19, 0x11, 0x12, 0x1A, 0x1B, 0x13, 0x0B, 0x03,
        0x02, 0x0A, 0x09, 0x01, 0x00, 0x08, 0x10, 0x18,
        0x20, 0x28, 0x30, 0x38, 0x39, 0x31, 0x29, 0x2A,
        0x32, 0x3A, 0x3B, 0x33, 0x2B, 0x23, 0x22, 0x21,
        0x1D, 0x15, 0x16, 0x1E, 0x1F, 0x17, 0x0F, 0x07,
        0x06, 0x0E, 0x0D, 0x05, 0x04, 0x0C, 0x14, 0x1C,
        0x24, 0x2C, 0x34, 0x3C, 0x3D, 0x35, 0x2D, 0x2E,
        0x36, 0x3E, 0x3F, 0x37, 0x2F, 0x27, 0x26, 0x25,
    },
    {
        0x03, 0x0B, 0x02, 0x0A, 0x01, 0x09, 0x00, 0x08,
        0x10, 0x18, 0x11, 0x19, 0x12, 0x1A, 0x13, 0x1B,
        0x23, 0x2B, 0x22, 0x2A, 0x21, 0x29, 0x20, 0x28,
        0x30, 0x38, 0x31, 0x39, 0x32, 0x3A, 0x33, 0x3B,
        0x3C, 0x34, 0x3D, 0x35, 0x3E, 0x36, 0x3F, 0x37,
        0x2F, 0x27, 0x2E, 0x26, 0x2D, 0x25, 0x2C, 0x24,
        0x1C, 0x14, 0x1D, 0x15, 0x1E, 0x16, 0x1F, 0x17,
        0x0F, 0x07, 0x0E, 0x06, 0x0D, 0x05, 0x0C, 0x04,
    },
    {
        0x18, 0x19, 0x10, 0x11, 0x08, 0x09, 0x00, 0x01,
        0x02, 0x03, 0x0A, 0x0B, 0x12, 0x13, 0x1A, 0x1B,
        0x1C, 0x1D, 0x14, 0x15, 0x0C, 0x0D, 0x04, 0x05,
        0x06, 0x07, 0x0E, 0x0F, 0x16, 0x17, 0x1E, 0x1F,
        0x27, 0x26, 0x2F, 0x2E, 0x37, 0x36, 0x3F, 0x3E,
        0x3D, 0x3C, 0x35, 0x34, 0x2D, 0x2C, 0x25, 0x24,
        0x23, 0x22, 0x2B, 0x2A, 0x33, 0x32, 0x3B, 0x3A,
        0x39, 0x38, 0x31, 0x30, 0x29, 0x28, 0x21, 0x20,
    },
    {
        0x00, 0x01, 0x02, 0x03, 0x08, 0x09, 0x0A, 0x0B,
        0x10, 0x11, 0x12, 0x13, 0x18, 0x19, 0x1A, 0x1B,
        0x20, 0x21, 0x22, 0x23, 0x28, 0x29, 0x2A, 0x2B,
        0x30, 0x31, 0x32, 0x33, 0x38, 0x39, 0x3A, 0x3B,
        0x04, 0x05, 0x06, 0x07, 0x0C, 0x0D, 0x0E, 0x0F,
        0x14, 0x15, 0x16, 0x17, 0x1C, 0x1D, 0x1E, 0x1F,
        0x24, 0x25, 0x26, 0x27, 0x2C, 0x2D, 0x2E, 0x2F,
        0x34, 0x35, 0x36, 0x37, 0x3C, 0x3D, 0x3E, 0x3F,
    },
    {
        0x06, 0x07, 0x0F, 0x0E, 0x0D, 0x05, 0x0C, 0x04,
        0x03, 0x0B, 0x02, 0x0A, 0x09, 0x01, 0x00, 0x08,
        0x10, 0x18, 0x11, 0x19, 0x12, 0x1A, 0x13, 0x1B,
        0x14, 0x1C, 0x15, 0x1D, 0x16, 0x1E, 0x17, 0x1F,
        0x27, 0x2F, 0x26, 0x2E, 0x25, 0x2D, 0x24, 0x2C,
        0x23, 0x2B, 0x22, 0x2A, 0x21, 0x29, 0x20, 0x28,
        0x31, 0x30, 0x38, 0x39, 0x3A, 0x32, 0x3B, 0x33,
        0x3C, 0x34, 0x3D, 0x35, 0x36, 0x37, 0x3F, 0x3E,
    },
    {
        0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
        0x0F, 0x0E, 0x0D, 0x0C, 0x0B, 0x0A, 0x09, 0x08,
        0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
        0x1F, 0x1E, 0x1D, 0x1C, 0x1B, 0x1A, 0x19, 0x18,
        0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
        0x2F, 0x2E, 0x2D, 0x2C, 0x2B, 0x2A, 0x29, 0x28,
        0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
        0x3F, 0x3E, 0x3D, 0x3C, 0x3B, 0x3A, 0x39, 0x38,
    },
    {
        0x00, 0x08, 0x09, 0x01, 0x02, 0x03, 0x0B, 0x0A,
        0x12, 0x13, 0x1B, 0x1A, 0x19, 0x11, 0x10, 0x18,
        0x20, 0x28, 0x29, 0x21, 0x22, 0x23, 0x2B, 0x2A,
        0x32, 0x31, 0x30, 0x38, 0x39, 0x3A, 0x3B, 0x33,
        0x34, 0x3C, 0x3D, 0x3E, 0x3F, 0x37, 0x36, 0x35,
        0x2D, 0x2C, 0x24, 0x25, 0x26, 0x2E, 0x2F, 0x27,
        0x1F, 0x17, 0x16, 0x1E, 0x1D, 0x1C, 0x14, 0x15,
        0x0D, 0x0C, 0x04, 0x05, 0x06, 0x0E, 0x0F, 0x07,
    },
    {
        0x18, 0x19, 0x10, 0x11, 0x08, 0x09, 0x00, 0x01,
        0x02, 0x03, 0x0A, 0x0B, 0x12, 0x13, 0x1A, 0x1B,
        0x1C, 0x1D, 0x14, 0x15, 0x0C, 0x0D, 0x04, 0x05,
        0x06, 0x07, 0x0E, 0x0F, 0x16, 0x17, 0x1E, 0x1F,
        0x26, 0x27, 0x2E, 0x2F, 0x36, 0x37, 0x3E, 0x3F,
        0x3C, 0x3D, 0x34, 0x35, 0x2C, 0x2D, 0x24, 0x25,
        0x22, 0x23, 0x2A, 0x2B, 0x32, 0x33, 0x3A, 0x3B,
        0x38, 0x39, 0x30, 0x31, 0x28, 0x29, 0x20, 0x21,
    },
    {
        0x00, 0x08, 0x01, 0x09, 0x02, 0x0A, 0x03, 0x0B,
        0x13, 0x1B, 0x12, 0x1A, 0x11, 0x19, 0x10, 0x18,
        0x20, 0x28, 0x21, 0x29, 0x22, 0x2A, 0x23, 0x2B,
        0x33, 0x3B, 0x32, 0x3A, 0x31, 0x39, 0x30, 0x38,
        0x3C, 0x34, 0x3D, 0x35, 0x3E, 0x36, 0x3F, 0x37,
        0x2F, 0x27, 0x2E, 0x26, 0x2D, 0x25, 0x2C, 0x24,
        0x1F, 0x17, 0x1E, 0x16, 0x1D, 0x15, 0x1C, 0x14,
        0x0C, 0x04, 0x0D, 0x05, 0x0E, 0x06, 0x0F, 0x07,
    },
    {
        0x00, 0x08, 0x10, 0x18, 0x19, 0x1A, 0x1B, 0x13,
        0x0B, 0x03, 0x02, 0x01, 0x09, 0x11, 0x12, 0x0A,
        0x04, 0x0C, 0x14, 0x1C, 0x1D, 0x1E, 0x1F, 0x17,
        0x0F, 0x07, 0x06, 0x05, 0x0D, 0x15, 0x16, 0x0E,
        0x24, 0x2C, 0x34, 0x3C, 0x3D, 0x3E, 0x3F, 0x37,
        0x2F, 0x27, 0x26, 0x25, 0x2D, 0x35, 0x36, 0x2E,
        0x20, 0x28, 0x30, 0x38, 0x39, 0x3A, 0x3B, 0x33,
        0x2B, 0x23, 0x22, 0x21, 0x29, 0x31, 0x32, 0x2A,
    },
    {
        0x00, 0x08, 0x09, 0x01, 0x02, 0x03, 0x0B, 0x0A,
        0x13, 0x1B, 0x1A, 0x12, 0x11, 0x10, 0x18, 0x19,
        0x21, 0x20, 0x28, 0x29, 0x2A, 0x22, 0x23, 0x2B,
        0x33, 0x3B, 0x3A, 0x32, 0x31, 0x39, 0x38, 0x30,
        0x34, 0x3C, 0x3D, 0x35, 0x36, 0x3E, 0x3F, 0x37,
        0x2F, 0x27, 0x26, 0x2E, 0x2D, 0x2C, 0x24, 0x25,
        0x1D, 0x1C, 0x14, 0x15, 0x16, 0x1E, 0x1F, 0x17,
        0x0E, 0x0F, 0x07, 0x06, 0x05, 0x0D, 0x0C, 0x04,
    },
    {
        0x18, 0x10, 0x08, 0x00, 0x01, 0x02, 0x03, 0x0B,
        0x13, 0x1B, 0x1A, 0x19, 0x11, 0x0A, 0x09, 0x12,
        0x1C, 0x14, 0x0C, 0x04, 0x05, 0x06, 0x07, 0x0F,
        0x17, 0x1F, 0x1E, 0x1D, 0x15, 0x0E, 0x0D, 0x16,
        0x3C, 0x34, 0x2C, 0x24, 0x25, 0x26, 0x27, 0x2F,
        0x37, 0x3F, 0x3E, 0x3D, 0x35, 0x2E, 0x2D, 0x36,
        0x38, 0x30, 0x28, 0x20, 0x21, 0x22, 0x23, 0x2B,
        0x33, 0x3B, 0x3A, 0x39, 0x31, 0x2A, 0x29, 0x32,
    },
    {
        0x00, 0x08, 0x09, 0x01, 0x02, 0x0A, 0x12, 0x11,
        0x10, 0x18, 0x19, 0x1A, 0x1B, 0x13, 0x0B, 0x03,
        0x07, 0x06, 0x0E, 0x0F, 0x17, 0x16, 0x15, 0x0D,
        0x05, 0x04, 0x0C, 0x14, 0x1C, 0x1D, 0x1E, 0x1F,
        0x3F, 0x3E, 0x36, 0x37, 0x2F, 0x2E, 0x2D, 0x35,
        0x3D, 0x3C, 0x34, 0x2C, 0x24, 0x25, 0x26, 0x27,
        0x38, 0x30, 0x31, 0x39, 0x3A, 0x32, 0x2A, 0x29,
        0x28, 0x20, 0x21, 0x22, 0x23, 0x2B, 0x33, 0x3B,
    },
    {
        0x00, 0x01, 0x08, 0x09, 0x10, 0x11, 0x18, 0x19,
        0x20, 0x21, 0x28, 0x29, 0x30, 0x31, 0x38, 0x39,
        0x3A, 0x3B, 0x32, 0x33, 0x2A, 0x2B, 0x22, 0x23,
        0x1A, 0x1B, 0x12, 0x13, 0x0A, 0x0B, 0x02, 0x03,
        0x04, 0x05, 0x0C, 0x0D, 0x14, 0x15, 0x1C, 0x1D,
        0x24, 0x25, 0x2C, 0x2D, 0x34, 0x35, 0x3C, 0x3D,
        0x3E, 0x3F, 0x36, 0x37, 0x2E, 0x2F, 0x26, 0x27,
        0x1E, 0x1F, 0x16, 0x17, 0x0E, 0x0F, 0x06, 0x07,
    }
};

static const uint32_t bink_intra_quant[16][64] = {
{
 0x00010000, 0x00016315, 0x00014E7B, 0x00016577, 0x00010000, 0x0000EEDA, 0x0000BE80, 0x0000611E,
 0x0001E83D, 0x0002A535, 0x0002F1E6, 0x0002724C, 0x00024102, 0x00017F9B, 0x0001083C, 0x0000A552,
 0x0002346F, 0x00030EE5, 0x0002C628, 0x00027F20, 0x00021F88, 0x0001DC53, 0x00014819, 0x0000A743,
 0x0001FBFA, 0x0002C096, 0x000297B5, 0x00023F32, 0x00027FAD, 0x0001F697, 0x00015A31, 0x00009688,
 0x0001D000, 0x00028396, 0x0002346F, 0x0001FBFA, 0x00025000, 0x0001AB6B, 0x00012669, 0x00008D43,
 0x00019247, 0x0001F9AA, 0x0001DC53, 0x000231B8, 0x0001D122, 0x000159B3, 0x0000EE1F, 0x000075ED,
 0x00012F12, 0x0001E06C, 0x0001C48C, 0x00019748, 0x0001490C, 0x00010288, 0x0000E0F1, 0x000072AD,
 0x0000CB10, 0x000119A8, 0x00014E86, 0x000122AF, 0x0000F735, 0x0000EF51, 0x0000A4D8, 0x00006517,
},
{
 0x00015555, 0x0001D971, 0x0001BDF9, 0x0001DC9F, 0x00015555, 0x00013E78, 0x0000FE00, 0x0000817D,
 0x00028AFC, 0x000386F1, 0x0003ED33, 0x00034311, 0x00030158, 0x0001FF7A, 0x0001604F, 0x0000DC6D,
 0x0002F095, 0x000413DC, 0x0003B2E0, 0x0003542A, 0x0002D4B5, 0x00027B19, 0x0001B577, 0x0000DF04,
 0x0002A54E, 0x0003AB73, 0x000374F1, 0x0002FEEE, 0x000354E7, 0x00029E1F, 0x0001CD96, 0x0000C8B6,
 0x00026AAB, 0x00035A1E, 0x0002F095, 0x0002A54E, 0x00031555, 0x000239E4, 0x0001888C, 0x0000BC59,
 0x0002185E, 0x0002A238, 0x00027B19, 0x0002ECF5, 0x00026C2D, 0x0001CCEE, 0x00013D7E, 0x00009D3C,
 0x00019418, 0x00028090, 0x00025B66, 0x00021F0B, 0x0001B6BB, 0x000158B5, 0x00012BEC, 0x000098E6,
 0x00010EC0, 0x0001778A, 0x0001BE09, 0x00018394, 0x0001499C, 0x00013F17, 0x0000DBCB, 0x000086C9,
},
{
 0x0001AAAB, 0x00024FCE, 0x00022D78, 0x000253C7, 0x0001AAAB, 0x00018E16, 0x00013D80, 0x0000A1DC,
 0x00032DBB, 0x000468AD, 0x0004E87F, 0x000413D5, 0x0003C1AE, 0x00027F58, 0x0001B863, 0x00011388,
 0x0003ACBA, 0x000518D3, 0x00049F98, 0x00042935, 0x000389E2, 0x000319DF, 0x000222D4, 0x000116C5,
 0x00034EA1, 0x0004964F, 0x0004522D, 0x0003BEA9, 0x00042A21, 0x000345A7, 0x000240FC, 0x0000FAE3,
 0x00030555, 0x000430A5, 0x0003ACBA, 0x00034EA1, 0x0003DAAB, 0x0002C85D, 0x0001EAAF, 0x0000EB6F,
 0x00029E76, 0x00034AC5, 0x000319DF, 0x0003A833, 0x00030738, 0x0002402A, 0x00018CDE, 0x0000C48A,
 0x0001F91E, 0x000320B4, 0x0002F23F, 0x0002A6CE, 0x00022469, 0x0001AEE2, 0x000176E7, 0x0000BF20,
 0x00015270, 0x0001D56D, 0x00022D8B, 0x0001E479, 0x00019C02, 0x00018EDD, 0x000112BE, 0x0000A87B,
},
{
 0x00020000, 0x0002C62A, 0x00029CF6, 0x0002CAEF, 0x00020000, 0x0001DDB4, 0x00017D01, 0x0000C23C,
 0x0003D07A, 0x00054A69, 0x0005E3CC, 0x0004E499, 0x00048204, 0x0002FF36, 0x00021077, 0x00014AA3,
 0x000468DF, 0x00061DCA, 0x00058C50, 0x0004FE3F, 0x00043F0F, 0x0003B8A6, 0x00029032, 0x00014E86,
 0x0003F7F5, 0x0005812C, 0x00052F69, 0x00047E65, 0x0004FF5A, 0x0003ED2E, 0x0002B461, 0x00012D11,
 0x0003A000, 0x0005072C, 0x000468DF, 0x0003F7F5, 0x0004A000, 0x000356D6, 0x00024CD2, 0x00011A85,
 0x0003248D, 0x0003F353, 0x0003B8A6, 0x00046370, 0x0003A243, 0x0002B365, 0x0001DC3E, 0x0000EBD9,
 0x00025E24, 0x0003C0D8, 0x00038919, 0x00032E91, 0x00029218, 0x00020510, 0x0001C1E2, 0x0000E559,
 0x00019620, 0x0002334F, 0x00029D0D, 0x0002455E, 0x0001EE69, 0x0001DEA2, 0x000149B0, 0x0000CA2D,
},
{
 0x0002AAAB, 0x0003B2E3, 0x00037BF2, 0x0003B93E, 0x0002AAAB, 0x00027CF0, 0x0001FC01, 0x000102FA,
 0x000515F8, 0x00070DE2, 0x0007DA65, 0x00068621, 0x000602B1, 0x0003FEF3, 0x0002C09F, 0x0001B8DA,
 0x0005E129, 0x000827B8, 0x000765C0, 0x0006A855, 0x0005A96A, 0x0004F632, 0x00036AED, 0x0001BE09,
 0x00054A9C, 0x000756E5, 0x0006E9E2, 0x0005FDDB, 0x0006A9CE, 0x00053C3E, 0x00039B2D, 0x0001916B,
 0x0004D555, 0x0006B43B, 0x0005E129, 0x00054A9C, 0x00062AAB, 0x000473C8, 0x00031118, 0x000178B2,
 0x000430BC, 0x0005446F, 0x0004F632, 0x0005D9EB, 0x0004D85A, 0x000399DC, 0x00027AFD, 0x00013A77,
 0x00032830, 0x00050121, 0x0004B6CC, 0x00043E16, 0x00036D76, 0x0002B16A, 0x000257D8, 0x000131CC,
 0x00021D80, 0x0002EF14, 0x00037C11, 0x00030728, 0x00029337, 0x00027E2E, 0x0001B796, 0x00010D91,
},
{
 0x00038000, 0x0004DACA, 0x000492AE, 0x0004E322, 0x00038000, 0x000343FB, 0x00029AC1, 0x000153E8,
 0x0006ACD5, 0x00094238, 0x000A4EA5, 0x0008900C, 0x0007E388, 0x00053E9F, 0x00039CD0, 0x0002429E,
 0x0007B786, 0x000AB421, 0x0009B58C, 0x0008BCEF, 0x00076E5B, 0x00068322, 0x00047C57, 0x0002496B,
 0x0006F1ED, 0x0009A20D, 0x000912F8, 0x0007DD30, 0x0008BEDE, 0x0006DF11, 0x0004BBAB, 0x00020EDD,
 0x00065800, 0x0008CC8E, 0x0007B786, 0x0006F1ED, 0x00081800, 0x0005D7F7, 0x00040670, 0x0001EE69,
 0x00057FF7, 0x0006E9D2, 0x00068322, 0x0007AE04, 0x00065BF6, 0x0004B9F1, 0x0003416C, 0x00019CBC,
 0x000424BF, 0x0006917B, 0x00062FEB, 0x0005917D, 0x00047FAA, 0x000388DC, 0x0003134C, 0x0001915C,
 0x0002C6B8, 0x0003D9CB, 0x000492D7, 0x0003F964, 0x00036138, 0x0003459C, 0x000240F5, 0x000161CF,
},
{
 0x00040000, 0x00058C54, 0x000539EC, 0x000595DD, 0x00040000, 0x0003BB68, 0x0002FA01, 0x00018477,
 0x0007A0F4, 0x000A94D3, 0x000BC798, 0x0009C932, 0x00090409, 0x0005FE6D, 0x000420EE, 0x00029547,
 0x0008D1BE, 0x000C3B94, 0x000B18A0, 0x0009FC7F, 0x00087E1F, 0x0007714C, 0x00052064, 0x00029D0D,
 0x0007EFEA, 0x000B0258, 0x000A5ED3, 0x0008FCC9, 0x0009FEB5, 0x0007DA5D, 0x000568C3, 0x00025A21,
 0x00074000, 0x000A0E59, 0x0008D1BE, 0x0007EFEA, 0x00094000, 0x0006ADAC, 0x000499A5, 0x0002350B,
 0x0006491A, 0x0007E6A7, 0x0007714C, 0x0008C6E0, 0x00074487, 0x000566CA, 0x0003B87B, 0x0001D7B3,
 0x0004BC48, 0x000781B1, 0x00071232, 0x00065D22, 0x00052430, 0x00040A20, 0x000383C5, 0x0001CAB3,
 0x00032C3F, 0x0004669F, 0x00053A1A, 0x00048ABC, 0x0003DCD3, 0x0003BD45, 0x00029361, 0x0001945A,
},
{
 0x00050000, 0x0006EF69, 0x00068867, 0x0006FB55, 0x00050000, 0x0004AA42, 0x0003B881, 0x0001E595,
 0x00098931, 0x000D3A07, 0x000EB97E, 0x000C3B7E, 0x000B450B, 0x00077E08, 0x0005292A, 0x00033A99,
 0x000B062D, 0x000F4A78, 0x000DDEC8, 0x000C7B9F, 0x000A9DA7, 0x00094D9F, 0x0006687D, 0x00034450,
 0x0009EBE4, 0x000DC2EE, 0x000CF687, 0x000B3BFB, 0x000C7E62, 0x0009D0F4, 0x0006C2F4, 0x0002F0AA,
 0x00091000, 0x000C91EF, 0x000B062D, 0x0009EBE4, 0x000B9000, 0x00085917, 0x0005C00E, 0x0002C24D,
 0x0007DB61, 0x0009E050, 0x00094D9F, 0x000AF898, 0x000915A8, 0x0006C07D, 0x0004A69A, 0x00024D9F,
 0x0005EB59, 0x0009621D, 0x0008D6BE, 0x0007F46A, 0x00066D3C, 0x00050CA7, 0x000464B6, 0x00023D5F,
 0x0003F74F, 0x00058046, 0x000688A0, 0x0005AD6B, 0x0004D407, 0x0004AC96, 0x00033839, 0x0001F971,
},
{
 0x00060000, 0x0008527E, 0x0007D6E1, 0x000860CC, 0x00060000, 0x0005991C, 0x00047702, 0x000246B3,
 0x000B716E, 0x000FDF3C, 0x0011AB63, 0x000EADCB, 0x000D860D, 0x0008FDA3, 0x00063165, 0x0003DFEA,
 0x000D3A9C, 0x0012595D, 0x0010A4F0, 0x000EFABE, 0x000CBD2E, 0x000B29F1, 0x0007B096, 0x0003EB93,
 0x000BE7DF, 0x00108384, 0x000F8E3C, 0x000D7B2E, 0x000EFE0F, 0x000BC78B, 0x00081D24, 0x00038732,
 0x000AE000, 0x000F1585, 0x000D3A9C, 0x000BE7DF, 0x000DE000, 0x000A0482, 0x0006E677, 0x00034F90,
 0x00096DA8, 0x000BD9FA, 0x000B29F1, 0x000D2A50, 0x000AE6CA, 0x00081A2F, 0x000594B9, 0x0002C38C,
 0x00071A6B, 0x000B4289, 0x000A9B4A, 0x00098BB2, 0x0007B649, 0x00060F2F, 0x000545A7, 0x0002B00C,
 0x0004C25F, 0x000699EE, 0x0007D727, 0x0006D01A, 0x0005CB3C, 0x00059BE7, 0x0003DD11, 0x00025E87,
},
{
 0x00080000, 0x000B18A8, 0x000A73D7, 0x000B2BBB, 0x00080000, 0x000776CF, 0x0005F402, 0x000308EF,
 0x000F41E8, 0x001529A5, 0x00178F2F, 0x00139264, 0x00120812, 0x000BFCD9, 0x000841DC, 0x00052A8E,
 0x0011A37B, 0x00187727, 0x00163140, 0x0013F8FE, 0x0010FC3E, 0x000EE297, 0x000A40C8, 0x00053A1A,
 0x000FDFD4, 0x001604B0, 0x0014BDA5, 0x0011F992, 0x0013FD69, 0x000FB4B9, 0x000AD186, 0x0004B442,
 0x000E8000, 0x00141CB1, 0x0011A37B, 0x000FDFD4, 0x00128000, 0x000D5B58, 0x00093349, 0x00046A15,
 0x000C9235, 0x000FCD4D, 0x000EE297, 0x00118DC0, 0x000E890D, 0x000ACD94, 0x000770F7, 0x0003AF65,
 0x0009788F, 0x000F0362, 0x000E2463, 0x000CBA43, 0x000A4861, 0x0008143F, 0x00070789, 0x00039565,
 0x0006587F, 0x0008CD3D, 0x000A7434, 0x00091577, 0x0007B9A6, 0x00077A89, 0x000526C2, 0x000328B4,
},
{
 0x000C0000, 0x0010A4FD, 0x000FADC3, 0x0010C198, 0x000C0000, 0x000B3237, 0x0008EE03, 0x00048D66,
 0x0016E2DB, 0x001FBE78, 0x002356C7, 0x001D5B96, 0x001B0C1A, 0x0011FB46, 0x000C62CA, 0x0007BFD5,
 0x001A7539, 0x0024B2BB, 0x002149E1, 0x001DF57D, 0x00197A5D, 0x001653E3, 0x000F612C, 0x0007D727,
 0x0017CFBD, 0x00210709, 0x001F1C78, 0x001AF65B, 0x001DFC1E, 0x00178F16, 0x00103A49, 0x00070E64,
 0x0015C000, 0x001E2B0A, 0x001A7539, 0x0017CFBD, 0x001BC000, 0x00140904, 0x000DCCEE, 0x00069F20,
 0x0012DB4F, 0x0017B3F4, 0x001653E3, 0x001A54A0, 0x0015CD94, 0x0010345E, 0x000B2972, 0x00058718,
 0x000E34D7, 0x00168513, 0x00153695, 0x00131765, 0x000F6C91, 0x000C1E5E, 0x000A8B4E, 0x00056018,
 0x000984BE, 0x000D33DC, 0x000FAE4E, 0x000DA033, 0x000B9678, 0x000B37CE, 0x0007BA22, 0x0004BD0E,
},
{
 0x00110000, 0x00179466, 0x0016362A, 0x0017BCED, 0x00110000, 0x000FDC79, 0x000CA685, 0x000672FB,
 0x00206C0C, 0x002CF87F, 0x00321044, 0x00299714, 0x00265125, 0x0019794E, 0x00118BF4, 0x000AFA6D,
 0x00257B66, 0x0033FD33, 0x002F28A9, 0x002A711B, 0x00241804, 0x001FA181, 0x0015C9A9, 0x000B1B77,
 0x0021BBA2, 0x002EC9F7, 0x002C12FF, 0x00263256, 0x002A7A80, 0x0021600A, 0x0016FD3C, 0x0009FF0D,
 0x001ED000, 0x002ABCF9, 0x00257B66, 0x0021BBA2, 0x00275000, 0x001C621B, 0x00138CFB, 0x0009616E,
 0x001AB6B0, 0x00219444, 0x001FA181, 0x00254D38, 0x001EE33C, 0x0016F4DB, 0x000FD00C, 0x0007D4B7,
 0x00142030, 0x001FE730, 0x001E0D52, 0x001B0BCF, 0x0015D9CE, 0x00112B06, 0x000EF004, 0x00079D77,
 0x000D7C0E, 0x0012B423, 0x001636EE, 0x00134D9E, 0x00106A80, 0x000FE464, 0x000AF25B, 0x0006B67F,
},
{
 0x00160000, 0x001E83CF, 0x001CBE90, 0x001EB842, 0x00160000, 0x001486BA, 0x00105F06, 0x00085891,
 0x0029F53D, 0x003A3286, 0x0040C9C2, 0x0035D293, 0x00319630, 0x0020F756, 0x0016B51E, 0x000E3506,
 0x00308193, 0x004347AC, 0x003D0771, 0x0036ECBA, 0x002EB5AA, 0x0028EF20, 0x001C3225, 0x000E5FC7,
 0x002BA786, 0x003C8CE5, 0x00390986, 0x00316E52, 0x0036F8E1, 0x002B30FE, 0x001DC030, 0x000CEFB7,
 0x0027E000, 0x00374EE7, 0x00308193, 0x002BA786, 0x0032E000, 0x0024BB33, 0x00194D09, 0x000C23BB,
 0x00229212, 0x002B7494, 0x0028EF20, 0x003045D0, 0x0027F8E4, 0x001DB557, 0x001476A6, 0x000A2256,
 0x001A0B89, 0x0029494D, 0x0026E410, 0x00230039, 0x001C470A, 0x001637AD, 0x001354B9, 0x0009DAD6,
 0x0011735D, 0x00183469, 0x001CBF8F, 0x0018FB09, 0x00153E87, 0x001490FA, 0x000E2A94, 0x0008AFF0,
},
{
 0x001C0000, 0x0026D64D, 0x00249572, 0x0027190E, 0x001C0000, 0x001A1FD6, 0x0014D607, 0x000A9F44,
 0x003566AA, 0x004A11C2, 0x00527525, 0x0044805E, 0x003F1C3E, 0x0029F4F9, 0x001CE683, 0x001214F0,
 0x003DBC30, 0x0055A109, 0x004DAC61, 0x0045E778, 0x003B72D9, 0x00341911, 0x0023E2BB, 0x00124B5B,
 0x00378F64, 0x004D1069, 0x004897C2, 0x003EE97F, 0x0045F6F0, 0x0036F889, 0x0025DD54, 0x001076E9,
 0x0032C000, 0x0046646C, 0x003DBC30, 0x00378F64, 0x0040C000, 0x002EBFB5, 0x00203380, 0x000F734B,
 0x002BFFB9, 0x00374E8E, 0x00341911, 0x003D7020, 0x0032DFAE, 0x0025CF86, 0x001A0B5F, 0x000CE5E2,
 0x002125F5, 0x00348BD6, 0x00317F5B, 0x002C8BEB, 0x0023FD53, 0x001C46DC, 0x00189A60, 0x000C8AE2,
 0x001635BC, 0x001ECE57, 0x002496B6, 0x001FCB22, 0x001B09C4, 0x001A2CE1, 0x001207A5, 0x000B0E77,
},
{
 0x00220000, 0x002F28CC, 0x002C6C53, 0x002F79DA, 0x00220000, 0x001FB8F1, 0x00194D09, 0x000CE5F7,
 0x0040D818, 0x0059F0FE, 0x00642089, 0x00532E29, 0x004CA24B, 0x0032F29C, 0x002317E8, 0x0015F4DB,
 0x004AF6CC, 0x0067FA67, 0x005E5152, 0x0054E237, 0x00483007, 0x003F4303, 0x002B9351, 0x001636EE,
 0x00437743, 0x005D93EE, 0x005825FE, 0x004C64AD, 0x0054F4FF, 0x0042C014, 0x002DFA79, 0x0013FE1A,
 0x003DA000, 0x005579F1, 0x004AF6CC, 0x00437743, 0x004EA000, 0x0038C437, 0x002719F7, 0x0012C2DB,
 0x00356D61, 0x00432888, 0x003F4303, 0x004A9A70, 0x003DC678, 0x002DE9B5, 0x001FA018, 0x000FA96E,
 0x00284060, 0x003FCE60, 0x003C1AA5, 0x0036179D, 0x002BB39B, 0x0022560C, 0x001DE007, 0x000F3AEE,
 0x001AF81B, 0x00256845, 0x002C6DDD, 0x00269B3C, 0x0020D500, 0x001FC8C8, 0x0015E4B7, 0x000D6CFE,
},
{
 0x002C0000, 0x003D079E, 0x00397D20, 0x003D7083, 0x002C0000, 0x00290D75, 0x0020BE0C, 0x0010B121,
 0x0053EA79, 0x0074650C, 0x00819383, 0x006BA525, 0x00632C61, 0x0041EEAC, 0x002D6A3B, 0x001C6A0C,
 0x00610326, 0x00868F57, 0x007A0EE2, 0x006DD974, 0x005D6B54, 0x0051DE40, 0x0038644B, 0x001CBF8F,
 0x00574F0B, 0x007919CA, 0x0072130C, 0x0062DCA3, 0x006DF1C2, 0x005661FB, 0x003B8060, 0x0019DF6D,
 0x004FC000, 0x006E9DCE, 0x00610326, 0x00574F0B, 0x0065C000, 0x00497665, 0x00329A12, 0x00184776,
 0x00452423, 0x0056E928, 0x0051DE40, 0x00608BA0, 0x004FF1C9, 0x003B6AAE, 0x0028ED4D, 0x001444AC,
 0x00341713, 0x0052929A, 0x004DC821, 0x00460071, 0x00388E14, 0x002C6F5A, 0x0026A973, 0x0013B5AD,
 0x0022E6BA, 0x003068D2, 0x00397F1E, 0x0031F611, 0x002A7D0F, 0x002921F4, 0x001C5528, 0x00115FDF,
}
};

static const uint32_t bink_inter_quant[16][64] = {
{
 0x00010000, 0x00017946, 0x00016363, 0x000152A7, 0x00012000, 0x0000E248, 0x0000A486, 0x000053E0,
 0x0001A5A9, 0x000248DC, 0x000243EC, 0x000209EA, 0x0001BBDA, 0x00015CBC, 0x0000F036, 0x00008095,
 0x0001B701, 0x000260EB, 0x00023D97, 0x00020437, 0x0001B701, 0x00016959, 0x0000F8E7, 0x00007EE4,
 0x00019DE9, 0x00023E1B, 0x00021CCC, 0x0001E6B4, 0x0001B0B9, 0x000153FD, 0x0000EA30, 0x00007763,
 0x00017000, 0x0001FE6E, 0x0001E0D1, 0x0001B0B9, 0x00018000, 0x00012DB5, 0x0000CFD2, 0x00006E5C,
 0x00012DB5, 0x0001A27B, 0x00018A33, 0x0001718D, 0x000146D9, 0x000100CE, 0x0000B0E4, 0x00005A2D,
 0x0000D87A, 0x00014449, 0x00013178, 0x000112EA, 0x0000E9CC, 0x0000B7B1, 0x00008337, 0x000042E5,
 0x00007B9A, 0x0000AB71, 0x0000AD08, 0x00009BB9, 0x0000846F, 0x00006B85, 0x00004A10, 0x00002831,
},
{
 0x00015555, 0x0001F708, 0x0001D9D9, 0x0001C389, 0x00018000, 0x00012DB5, 0x0000DB5D, 0x00006FD5,
 0x00023237, 0x00030BD0, 0x0003053B, 0x0002B7E3, 0x00024FCE, 0x0001D0FA, 0x00014048, 0x0000AB71,
 0x00024957, 0x00032BE4, 0x0002FCC9, 0x0002B04A, 0x00024957, 0x0001E1CC, 0x00014BDE, 0x0000A92F,
 0x000227E1, 0x0002FD7A, 0x0002D110, 0x000288F1, 0x000240F7, 0x0001C551, 0x00013840, 0x00009F2F,
 0x0001EAAB, 0x0002A893, 0x00028116, 0x000240F7, 0x00020000, 0x00019247, 0x00011518, 0x00009325,
 0x00019247, 0x00022DF9, 0x00020D99, 0x0001ECBC, 0x0001B3CC, 0x00015668, 0x0000EBDA, 0x0000783D,
 0x000120A3, 0x0001B061, 0x0001974B, 0x00016E8E, 0x000137BB, 0x0000F4ED, 0x0000AEF4, 0x00005931,
 0x0000A4CE, 0x0000E497, 0x0000E6B5, 0x0000CFA2, 0x0000B093, 0x00008F5C, 0x000062BF, 0x00003597,
},
{
 0x0001AAAB, 0x000274CB, 0x0002504F, 0x0002346C, 0x0001E000, 0x00017922, 0x00011235, 0x00008BCA,
 0x0002BEC4, 0x0003CEC4, 0x0003C689, 0x000365DC, 0x0002E3C1, 0x00024539, 0x0001905A, 0x0000D64D,
 0x0002DBAD, 0x0003F6DD, 0x0003BBFB, 0x00035C5C, 0x0002DBAD, 0x00025A40, 0x00019ED6, 0x0000D37B,
 0x0002B1D9, 0x0003BCD8, 0x00038554, 0x00032B2D, 0x0002D134, 0x000236A5, 0x00018650, 0x0000C6FB,
 0x00026555, 0x000352B8, 0x0003215C, 0x0002D134, 0x00028000, 0x0001F6D8, 0x00015A5E, 0x0000B7EF,
 0x0001F6D8, 0x0002B977, 0x00029100, 0x000267EB, 0x000220C0, 0x0001AC02, 0x000126D1, 0x0000964C,
 0x000168CC, 0x00021C7A, 0x0001FD1E, 0x0001CA31, 0x000185A9, 0x00013228, 0x0000DAB2, 0x00006F7D,
 0x0000CE01, 0x00011DBD, 0x00012062, 0x0001038A, 0x0000DCB8, 0x0000B333, 0x00007B6F, 0x000042FC,
},
{
 0x00020000, 0x0002F28D, 0x0002C6C5, 0x0002A54E, 0x00024000, 0x0001C48F, 0x0001490C, 0x0000A7BF,
 0x00034B52, 0x000491B8, 0x000487D8, 0x000413D5, 0x000377B5, 0x0002B977, 0x0001E06C, 0x0001012A,
 0x00036E03, 0x0004C1D6, 0x00047B2D, 0x0004086E, 0x00036E03, 0x0002D2B3, 0x0001F1CE, 0x0000FDC7,
 0x00033BD1, 0x00047C37, 0x00043998, 0x0003CD69, 0x00036172, 0x0002A7FA, 0x0001D460, 0x0000EEC7,
 0x0002E000, 0x0003FCDD, 0x0003C1A1, 0x00036172, 0x00030000, 0x00025B6A, 0x00019FA3, 0x0000DCB8,
 0x00025B6A, 0x000344F5, 0x00031466, 0x0002E31B, 0x00028DB3, 0x0002019B, 0x000161C7, 0x0000B45B,
 0x0001B0F5, 0x00028892, 0x000262F1, 0x000225D5, 0x0001D398, 0x00016F63, 0x0001066F, 0x000085C9,
 0x0000F735, 0x000156E2, 0x00015A10, 0x00013772, 0x000108DD, 0x0000D70A, 0x0000941F, 0x00005062,
},
{
 0x0002AAAB, 0x0003EE11, 0x0003B3B2, 0x00038713, 0x00030000, 0x00025B6A, 0x0001B6BB, 0x0000DFAA,
 0x0004646D, 0x000617A0, 0x00060A75, 0x00056FC6, 0x00049F9B, 0x0003A1F4, 0x00028090, 0x000156E2,
 0x000492AE, 0x000657C8, 0x0005F991, 0x00056093, 0x000492AE, 0x0003C399, 0x000297BD, 0x0001525F,
 0x00044FC1, 0x0005FAF4, 0x0005A220, 0x000511E1, 0x000481ED, 0x00038AA2, 0x00027080, 0x00013E5E,
 0x0003D555, 0x00055126, 0x0005022D, 0x000481ED, 0x00040000, 0x0003248D, 0x00022A2F, 0x0001264B,
 0x0003248D, 0x00045BF2, 0x00041B33, 0x0003D979, 0x00036799, 0x0002ACCF, 0x0001D7B5, 0x0000F079,
 0x00024147, 0x000360C3, 0x00032E96, 0x0002DD1C, 0x00026F75, 0x0001E9D9, 0x00015DE9, 0x0000B262,
 0x0001499C, 0x0001C92E, 0x0001CD6A, 0x00019F43, 0x00016127, 0x00011EB8, 0x0000C57F, 0x00006B2D,
},
{
 0x00038000, 0x00052876, 0x0004DBD9, 0x0004A148, 0x0003F000, 0x000317FB, 0x00023FD5, 0x0001258F,
 0x0005C3CF, 0x0007FF02, 0x0007EDBA, 0x000722B4, 0x0006117C, 0x0004C491, 0x000348BD, 0x0001C209,
 0x00060085, 0x00085336, 0x0007D78F, 0x00070EC1, 0x00060085, 0x0004F0B9, 0x00036728, 0x0001BC1C,
 0x0005A8AE, 0x0007D960, 0x000764CA, 0x0006A777, 0x0005EA87, 0x0004A5F5, 0x000333A8, 0x0001A1DB,
 0x00050800, 0x0006FA82, 0x000692DA, 0x0005EA87, 0x00054000, 0x00041FF9, 0x0002D75E, 0x00018242,
 0x00041FF9, 0x0005B8AE, 0x000563B2, 0x00050D6E, 0x000477F9, 0x000382D0, 0x00026B1D, 0x00013B9F,
 0x0002F5AD, 0x00046F00, 0x00042D25, 0x0003C235, 0x0003324A, 0x000282ED, 0x0001CB42, 0x0000EA21,
 0x0001B09C, 0x0002580C, 0x00025D9B, 0x00022108, 0x0001CF83, 0x00017851, 0x00010336, 0x00008CAC,
},
{
 0x00040000, 0x0005E519, 0x00058D8A, 0x00054A9C, 0x00048000, 0x0003891F, 0x00029218, 0x00014F7E,
 0x000696A4, 0x00092370, 0x00090FB0, 0x000827AA, 0x0006EF69, 0x000572EE, 0x0003C0D8, 0x00020254,
 0x0006DC05, 0x000983AC, 0x0008F65A, 0x000810DD, 0x0006DC05, 0x0005A565, 0x0003E39B, 0x0001FB8E,
 0x000677A2, 0x0008F86E, 0x00087330, 0x00079AD1, 0x0006C2E4, 0x00054FF3, 0x0003A8C0, 0x0001DD8D,
 0x0005C000, 0x0007F9B9, 0x00078343, 0x0006C2E4, 0x00060000, 0x0004B6D4, 0x00033F47, 0x0001B970,
 0x0004B6D4, 0x000689EB, 0x000628CC, 0x0005C635, 0x00051B65, 0x00040337, 0x0002C38F, 0x000168B6,
 0x000361EA, 0x00051124, 0x0004C5E1, 0x00044BAA, 0x0003A730, 0x0002DEC6, 0x00020CDD, 0x00010B93,
 0x0001EE69, 0x0002ADC5, 0x0002B41F, 0x00026EE5, 0x000211BA, 0x0001AE14, 0x0001283E, 0x0000A0C4,
},
{
 0x00050000, 0x00075E60, 0x0006F0ED, 0x00069D43, 0x0005A000, 0x00046B67, 0x0003369E, 0x0001A35E,
 0x00083C4D, 0x000B6C4C, 0x000B539C, 0x000A3194, 0x0008AB44, 0x0006CFAA, 0x0004B10F, 0x000282E8,
 0x00089307, 0x000BE497, 0x000B33F1, 0x000A1514, 0x00089307, 0x00070EBF, 0x0004DC82, 0x00027A72,
 0x0008158B, 0x000B3689, 0x000A8FFC, 0x00098186, 0x0008739C, 0x0006A3F0, 0x000492F0, 0x000254F0,
 0x00073000, 0x0009F827, 0x00096413, 0x0008739C, 0x00078000, 0x0005E489, 0x00040F19, 0x000227CC,
 0x0005E489, 0x00082C66, 0x0007B2FF, 0x000737C2, 0x0006623F, 0x00050405, 0x00037473, 0x0001C2E3,
 0x00043A64, 0x0006556D, 0x0005F75A, 0x00055E94, 0x000490FC, 0x00039677, 0x00029015, 0x00014E78,
 0x00026A04, 0x00035936, 0x00036127, 0x00030A9E, 0x00029629, 0x00021999, 0x0001724E, 0x0000C8F5,
},
{
 0x00060000, 0x0008D7A6, 0x00085450, 0x0007EFEA, 0x0006C000, 0x00054DAE, 0x0003DB24, 0x0001F73E,
 0x0009E1F6, 0x000DB528, 0x000D9788, 0x000C3B7E, 0x000A671E, 0x00082C66, 0x0005A145, 0x0003037D,
 0x000A4A08, 0x000E4582, 0x000D7187, 0x000C194B, 0x000A4A08, 0x00087818, 0x0005D569, 0x0002F955,
 0x0009B373, 0x000D74A5, 0x000CACC8, 0x000B683A, 0x000A2455, 0x0007F7ED, 0x00057D20, 0x0002CC54,
 0x0008A000, 0x000BF696, 0x000B44E4, 0x000A2455, 0x00090000, 0x0007123E, 0x0004DEEA, 0x00029629,
 0x0007123E, 0x0009CEE0, 0x00093D32, 0x0008A950, 0x0007A918, 0x000604D2, 0x00042556, 0x00021D11,
 0x000512DF, 0x000799B6, 0x000728D2, 0x0006717F, 0x00057AC8, 0x00044E28, 0x0003134C, 0x0001915C,
 0x0002E59E, 0x000404A7, 0x00040E2F, 0x0003A657, 0x00031A97, 0x0002851E, 0x0001BC5D, 0x0000F126,
},
{
 0x00080000, 0x000BCA33, 0x000B1B15, 0x000A9538, 0x00090000, 0x0007123E, 0x00052430, 0x00029EFD,
 0x000D2D48, 0x001246E0, 0x00121F5F, 0x00104F53, 0x000DDED2, 0x000AE5DD, 0x000781B1, 0x000404A7,
 0x000DB80B, 0x00130757, 0x0011ECB4, 0x001021B9, 0x000DB80B, 0x000B4ACB, 0x0007C736, 0x0003F71D,
 0x000CEF44, 0x0011F0DC, 0x0010E661, 0x000F35A3, 0x000D85C7, 0x000A9FE7, 0x00075180, 0x0003BB1A,
 0x000B8000, 0x000FF372, 0x000F0686, 0x000D85C7, 0x000C0000, 0x00096DA8, 0x00067E8E, 0x000372E1,
 0x00096DA8, 0x000D13D6, 0x000C5198, 0x000B8C6A, 0x000A36CB, 0x0008066E, 0x0005871E, 0x0002D16B,
 0x0006C3D4, 0x000A2248, 0x00098BC3, 0x00089754, 0x00074E60, 0x0005BD8B, 0x000419BB, 0x00021726,
 0x0003DCD3, 0x00055B8A, 0x0005683E, 0x0004DDC9, 0x00042374, 0x00035C28, 0x0002507C, 0x00014188,
},
{
 0x000C0000, 0x0011AF4C, 0x0010A89F, 0x000FDFD4, 0x000D8000, 0x000A9B5D, 0x0007B649, 0x0003EE7B,
 0x0013C3EC, 0x001B6A50, 0x001B2F0F, 0x001876FD, 0x0014CE3C, 0x001058CB, 0x000B4289, 0x000606FB,
 0x00149410, 0x001C8B03, 0x001AE30E, 0x00183296, 0x00149410, 0x0010F030, 0x000BAAD2, 0x0005F2AB,
 0x001366E6, 0x001AE949, 0x00195991, 0x0016D074, 0x001448AB, 0x000FEFDA, 0x000AFA40, 0x000598A7,
 0x00114000, 0x0017ED2B, 0x001689C8, 0x001448AB, 0x00120000, 0x000E247C, 0x0009BDD5, 0x00052C51,
 0x000E247C, 0x00139DC1, 0x00127A63, 0x0011529F, 0x000F5230, 0x000C09A5, 0x00084AAC, 0x00043A21,
 0x000A25BE, 0x000F336D, 0x000E51A4, 0x000CE2FE, 0x000AF590, 0x00089C51, 0x00062698, 0x000322B9,
 0x0005CB3C, 0x0008094E, 0x00081C5D, 0x00074CAE, 0x0006352E, 0x00050A3B, 0x000378BA, 0x0001E24D,
},
{
 0x00110000, 0x00190DAC, 0x0017998C, 0x00167D16, 0x00132000, 0x000F06C3, 0x000AECE7, 0x000591D9,
 0x001C0039, 0x0026D69C, 0x002682AB, 0x0022A891, 0x001D797F, 0x00172876, 0x000FF398, 0x000889E3,
 0x001D2717, 0x00286F9A, 0x002616FF, 0x002247AA, 0x001D2717, 0x0017FEEF, 0x00108754, 0x00086D1D,
 0x001B7C71, 0x00261FD3, 0x0023E98D, 0x002051FA, 0x001CBC47, 0x001693CA, 0x000F8D30, 0x0007ED98,
 0x00187000, 0x0021E552, 0x001FEDDC, 0x001CBC47, 0x00198000, 0x00140904, 0x000DCCEE, 0x0007541E,
 0x00140904, 0x001BCA27, 0x001A2D62, 0x00188A62, 0x0015B46F, 0x00110DAA, 0x000BBF1F, 0x0005FD04,
 0x000E6022, 0x001588DA, 0x001448FE, 0x00124192, 0x000F868B, 0x000C32C8, 0x0008B6AD, 0x00047130,
 0x00083540, 0x000B6284, 0x000B7D84, 0x000A574B, 0x0008CB57, 0x000723D4, 0x0004EB08, 0x0002AB42,
},
{
 0x00160000, 0x00206C0C, 0x001E8A79, 0x001D1A59, 0x0018C000, 0x0013722A, 0x000E2385, 0x00073537,
 0x00243C86, 0x003242E8, 0x0031D646, 0x002CDA25, 0x002624C3, 0x001DF820, 0x0014A4A7, 0x000B0CCC,
 0x0025BA1D, 0x00345430, 0x00314AEF, 0x002C5CBE, 0x0025BA1D, 0x001F0DAE, 0x001563D6, 0x000AE78E,
 0x002391FB, 0x0031565C, 0x002E798A, 0x0029D380, 0x00252FE4, 0x001D37BB, 0x00142021, 0x000A4288,
 0x001FA000, 0x002BDD7A, 0x002951EF, 0x00252FE4, 0x00210000, 0x0019ED8D, 0x0011DC06, 0x00097BEA,
 0x0019ED8D, 0x0023F68C, 0x0021E061, 0x001FC224, 0x001C16AE, 0x001611AE, 0x000F3391, 0x0007BFE7,
 0x00129A87, 0x001BDE47, 0x001A4058, 0x0017A026, 0x00141787, 0x000FC93E, 0x000B46C1, 0x0005BFA8,
 0x000A9F44, 0x000EBBBA, 0x000EDEAB, 0x000D61E9, 0x000B617F, 0x00093D6D, 0x00065D55, 0x00037437,
},
{
 0x001C0000, 0x002943B2, 0x0026DEC9, 0x00250A43, 0x001F8000, 0x0018BFD8, 0x0011FEA9, 0x00092C75,
 0x002E1E7C, 0x003FF810, 0x003F6DCE, 0x003915A3, 0x00308BE1, 0x00262485, 0x001A45EB, 0x000E1049,
 0x00300425, 0x004299B2, 0x003EBC76, 0x00387608, 0x00300425, 0x002785C6, 0x001B393F, 0x000DE0E4,
 0x002D456E, 0x003ECB00, 0x003B2652, 0x00353BBA, 0x002F5439, 0x00252FA8, 0x00199D41, 0x000D0EDC,
 0x00284000, 0x0037D40F, 0x003496D3, 0x002F5439, 0x002A0000, 0x0020FFCB, 0x0016BAF1, 0x000C1213,
 0x0020FFCB, 0x002DC56D, 0x002B1D93, 0x00286B74, 0x0023BFC6, 0x001C1681, 0x001358E8, 0x0009DCF8,
 0x0017AD66, 0x002377FE, 0x0021692A, 0x001E11A5, 0x0019924F, 0x00141767, 0x000E5A0D, 0x00075104,
 0x000D84E2, 0x0012C062, 0x0012ECDA, 0x00110840, 0x000E7C16, 0x000BC28A, 0x000819B2, 0x0004655D,
},
{
 0x00220000, 0x00321B58, 0x002F3318, 0x002CFA2D, 0x00264000, 0x001E0D86, 0x0015D9CE, 0x000B23B2,
 0x00380072, 0x004DAD38, 0x004D0556, 0x00455122, 0x003AF2FE, 0x002E50EB, 0x001FE730, 0x001113C7,
 0x003A4E2D, 0x0050DF33, 0x004C2DFD, 0x00448F54, 0x003A4E2D, 0x002FFDDF, 0x00210EA8, 0x0010DA39,
 0x0036F8E1, 0x004C3FA5, 0x0047D31B, 0x0040A3F5, 0x0039788E, 0x002D2795, 0x001F1A61, 0x000FDB2F,
 0x0030E000, 0x0043CAA5, 0x003FDBB7, 0x0039788E, 0x00330000, 0x00281209, 0x001B99DB, 0x000EA83B,
 0x00281209, 0x0037944D, 0x00345AC4, 0x003114C3, 0x002B68DF, 0x00221B53, 0x00177E3E, 0x000BFA09,
 0x001CC044, 0x002B11B4, 0x002891FC, 0x00248324, 0x001F0D17, 0x0018658F, 0x00116D5A, 0x0008E260,
 0x00106A80, 0x0016C509, 0x0016FB08, 0x0014AE97, 0x001196AE, 0x000E47A8, 0x0009D60F, 0x00055684,
},
{
 0x002C0000, 0x0040D818, 0x003D14F2, 0x003A34B2, 0x00318000, 0x0026E454, 0x001C470A, 0x000E6A6E,
 0x0048790C, 0x006485D0, 0x0063AC8D, 0x0059B44A, 0x004C4986, 0x003BF03F, 0x0029494D, 0x00161998,
 0x004B743A, 0x0068A861, 0x006295DE, 0x0058B97B, 0x004B743A, 0x003E1B5C, 0x002AC7AC, 0x0015CF1D,
 0x004723F6, 0x0062ACB8, 0x005CF313, 0x0053A701, 0x004A5FC7, 0x003A6F75, 0x00284041, 0x00148510,
 0x003F4000, 0x0057BAF3, 0x0052A3DE, 0x004A5FC7, 0x00420000, 0x0033DB1A, 0x0023B80D, 0x0012F7D4,
 0x0033DB1A, 0x0047ED19, 0x0043C0C2, 0x003F8448, 0x00382D5C, 0x002C235D, 0x001E6723, 0x000F7FCF,
 0x0025350D, 0x0037BC8E, 0x003480B0, 0x002F404C, 0x00282F0E, 0x001F927D, 0x00168D83, 0x000B7F50,
 0x00153E87, 0x001D7775, 0x001DBD56, 0x001AC3D2, 0x0016C2FF, 0x00127AD9, 0x000CBAAA, 0x0006E86E,
}
};

#endif /* AVCODEC_BINKDATA_H */
