#include "geolocation.h"

#include <QDebug>
#include <QVariant>

GeoLocation::GeoLocation(QObject *parent) :
    QObject(parent)
{
    m_pSource = NULL;
    m_pSatellite = NULL;

    /*
    m_pSource->startUpdates();
    m_pSatellite->startUpdates();
    m_isUpdating = true;
    */

    m_isUpdating = false;
}

GeoLocation::~GeoLocation() {
    if ( m_pSource ) { m_pSource->stopUpdates(); delete m_pSource; }
    if ( m_pSatellite ) { m_pSatellite->stopUpdates(); delete m_pSatellite; }
}

double GeoLocation::latitude() {
    return m_lastLocation.coordinate().latitude();
}

double GeoLocation::longitude() {
    return m_lastLocation.coordinate().longitude();
}

qreal GeoLocation::horizontalAccuracy() {
    return m_lastLocation.attribute(QGeoPositionInfo::HorizontalAccuracy);
}

bool GeoLocation::isUpdating() {
    return m_isUpdating;
}

void GeoLocation::positionUpdated ( const QGeoPositionInfo & update )  {
    /*
    QGeoCoordinate coord = update.coordinate();
    qDebug() << "Position Updated: " << coord.latitude() << ", " << coord.longitude();
    qDebug() << "QGeoPositionInfo::Direction:" << update.attribute(QGeoPositionInfo::Direction);
    qDebug() << "QGeoPositionInfo::GroundSpeed:" << update.attribute(QGeoPositionInfo::GroundSpeed);
    qDebug() << "QGeoPositionInfo::VerticalSpeed:" << update.attribute(QGeoPositionInfo::VerticalSpeed);
    qDebug() << "QGeoPositionInfo::MagneticVariation:" << update.attribute(QGeoPositionInfo::MagneticVariation);
    qDebug() << "QGeoPositionInfo::HorizontalAccuracy:" << update.attribute(QGeoPositionInfo::HorizontalAccuracy);
    qDebug() << "QGeoPositionInfo::VerticalAccuracy:" << update.attribute(QGeoPositionInfo::VerticalAccuracy);
    */

    m_lastLocation = update;
    emit updated();
}

void GeoLocation::setUpdatesPerHour(int updates) {
    qDebug() << "GeoLocation::setUpdatesPerHour: " << updates;
    if (!updates) {
        if ( m_pSource ) m_pSource->stopUpdates();
        if ( m_pSatellite ) m_pSatellite->stopUpdates();
        m_isUpdating = false;
        return;
    }

    if ( !m_pSatellite ) {
        qDebug() << "Satellite";
        m_pSatellite = QGeoSatelliteInfoSource::createDefaultSource(this);
    }

    if ( !m_pSource ) {
        qDebug() << "Create Default Source";
        m_pSource = QGeoPositionInfoSource::createDefaultSource(this);
        connect(m_pSource, SIGNAL(positionUpdated(QGeoPositionInfo)), SLOT(positionUpdated(QGeoPositionInfo)));
    }

    m_pSource->setUpdateInterval(60*60*1000/updates);
    m_pSource->startUpdates();
    m_pSatellite->startUpdates();
    m_isUpdating = true;
}

QString GeoLocation::toString() {
    return QString("%1, %2").arg(m_lastLocation.coordinate().latitude(), m_lastLocation.coordinate().longitude());
}
