#include "finddlg.h"
#include "ui_finddlg.h"

#include <QMessageBox>

FindDlg::FindDlg(QNetworkAccessManager *pNetAccessMngr, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::FindDlg),
    m_requester(pNetAccessMngr, this)
{
    ui->setupUi(this);
    connect(&m_requester, SIGNAL(finish(bool,QString)), SLOT(onFinish(bool,QString)));
}

FindDlg::FindDlg(GeocodeRequester& requester, QString address, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::FindDlg),
    m_requester(requester.networkAccessManager(), this)
{
    ui->setupUi(this);
    connect(&m_requester, SIGNAL(finish(bool,QString)), SLOT(onFinish(bool,QString)));

    m_items.clear();
    for ( int c=0; c<requester.m_address.length(); c++ ) {
        m_items.append(&requester.m_address[c]);
        ui->listWidget->addItem(requester.m_address[c].description());
    }

    ui->lineEdit->setText(address);
}

FindDlg::~FindDlg() {
    delete ui;
}

void FindDlg::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void FindDlg::on_pushButton_clicked() {
    ui->pushButton->setEnabled(false);

    m_items.clear();
    ui->listWidget->clear();

    m_requester.query(ui->lineEdit->text());
}

void FindDlg::onFinish(bool isSuccess, QString errorMessage) {
    ui->pushButton->setEnabled(true);

    if ( !isSuccess ) {
        QMessageBox::warning(this, "Find Address", errorMessage);
        return;
    }

    for ( int c=0; c<m_requester.m_address.length(); c++ ) {
        m_items.append(&m_requester.m_address[c]);
        ui->listWidget->addItem(m_requester.m_address[c].description());
    }
}

void FindDlg::on_listWidget_clicked(QModelIndex index) {
#ifdef Q_WS_MAEMO5
    if ( index.row()<0 || index.row()>=m_requester.m_address.length() ) return;
    m_selectedAddress = m_requester.m_address[index.row()];
    accept();
#endif
}

void FindDlg::on_listWidget_doubleClicked(QModelIndex index) {
#ifndef Q_WS_MAEMO5
    if ( index.row()<0 || index.row()>=m_items.length() ) return;
    m_selectedAddress = *m_items[index.row()];
    accept();
#endif
}
