#ifndef GEOCODEREQUESTER_H
#define GEOCODEREQUESTER_H

#include <QObject>
#include <QNetworkReply>
#include <QList>
#include <QStringList>

#include "location.h"

class GeocodeAddress : public Location {
public:
    QStringList m_types;
    QString m_location_type;
};

class GeocodeRequester : public QObject
{
    Q_OBJECT

public:
    explicit GeocodeRequester(QNetworkAccessManager *netAccessMngr, QObject *parent = 0);
    ~GeocodeRequester();

public:
    bool query(QString address);
    QNetworkAccessManager *networkAccessManager() { return m_pNetAccessMngr; }

public:
    QList<GeocodeAddress> m_address;

private:
    QNetworkReply *m_pReply;
    QNetworkAccessManager *m_pNetAccessMngr;

signals:
    void finish(bool success, QString error);

public slots:
    void onFinished();
};

#endif // GEOCODEREQUESTER_H
