/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef FINGERSCROLLEVENTFILTER_H
#define FINGERSCROLLEVENTFILTER_H

#include <QObject>
#include <QWebView>
#include <QMouseEvent>
#include <QTime>
#include <QBasicTimer>

class QMainWindow;

class FingerScrollEventFilter : public QObject
{
    Q_OBJECT

public:
    typedef enum {
        Steady,
        Pressed,
        ManualScroll,
        AutoScroll,
        Stop
    } State;

public:
    explicit FingerScrollEventFilter(QWebView *pView = 0);

protected:
    virtual bool eventFilter(QObject *, QEvent *e);
    virtual void timerEvent(QTimerEvent *event);

signals:
    void click(QMouseEvent *pEvent);
    void scroll(QPoint off);

private:
    void tick();

    bool mousePressEvent(QMouseEvent *pEvent);
    bool mouseMoveEvent(QMouseEvent *pEvent);
    bool mouseReleaseEvent(QMouseEvent *pEvent);
    bool keyPressEvent(QKeyEvent *pEvent);

    void startTicker(int interval);
    void stopTicker();
    QMainWindow *mainWindow(QWidget *pParent=NULL);

private:
    bool m_isMousePressed;

    State m_state;
    int m_threshold;
    QPoint m_pressPos;
    QPoint m_lastPos;

    QPoint m_speed;
    QTime m_timeStamp;
    QList<QEvent*> m_ignoreList;

    // flickable
    QBasicTimer m_timer;
};

#endif // FINGERSCROLLEVENTFILTER_H
