#include "startwidget.h"
#include "exercise.h"

#include <QPushButton>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QFrame>
#include <QLabel>

StartWidget::StartWidget(QWidget *parent)
    : QWidget(parent)
{
    QVBoxLayout *vbLayout = new QVBoxLayout;
    vbLayout->addStretch();
//    //Create frame with "Continue reading" button to continue reading of last text
//    QFrame *frame = new QFrame;
//    frame->setFrameStyle(QFrame::StyledPanel);
//
//    QVBoxLayout *vbLayout2 = new QVBoxLayout(frame);
//
//    QPushButton *btnContinue = new QPushButton(tr("Continue reading"));
//    connect(btnContinue,SIGNAL(clicked()),this,SLOT(setContinueReading()));
//
//    QLabel *lbl = new QLabel(tr("History"));
//
//    vbLayout2->addWidget(lbl);
//    vbLayout2->addStretch();
//    vbLayout2->addWidget(btnContinue);
//    vbLayout2->addStretch();
//
//    vbLayout->addWidget(frame);
//    vbLayout->addStretch();

    //Create frame with buttons for selecting reading mode: rapid and classic
    QFrame *frame = new QFrame;
    frame->setFrameStyle(QFrame::StyledPanel);

    QVBoxLayout *vbLayout2 = new QVBoxLayout(frame);

    QPushButton *btnRapid = new QPushButton(tr("Rapid"));
    connect(btnRapid,SIGNAL(clicked()),this,SLOT(setModeRapid()));

    QPushButton *btnClassic = new QPushButton(tr("Classic"));
    connect(btnClassic,SIGNAL(clicked()),this,SLOT(setModeClassic()));

    QLabel *lbl = new QLabel(tr("Reading mode"));

    vbLayout2->addWidget(lbl);
    vbLayout2->addStretch();
    QHBoxLayout *hbLayout = new QHBoxLayout;
    hbLayout->addWidget(btnRapid);
    hbLayout->addWidget(btnClassic);
    vbLayout2->addLayout(hbLayout);

    vbLayout->addWidget(frame);
    vbLayout->addStretch();

    //Create frame with buttons for selecting exercises for speed reading
    frame = new QFrame;
    frame->setFrameStyle(QFrame::StyledPanel);

    vbLayout2 = new QVBoxLayout(frame);

    hbLayout = new QHBoxLayout;

    QPushButton *btnShulte = new QPushButton(tr("Shulte's table"));
    connect(btnShulte,SIGNAL(clicked()),this,SLOT(setExerciseShulte()));

//    QPushButton *btnNumbers = new QPushButton(tr("Moving numbers"));
//    connect(btnNumbers,SIGNAL(clicked()),this,SLOT(setExerciseNumbers()));

//    QPushButton *btnFlick = new QPushButton(tr("Flicking numbers"));
//    connect(btnFlick,SIGNAL(clicked()),this,SLOT(setExerciseFlick()));

    lbl = new QLabel(tr("Exercises"));

    vbLayout2->addWidget(lbl);
    vbLayout2->addStretch();
    hbLayout->addWidget(btnShulte);
//    hbLayout->addWidget(btnNumbers);
//    hbLayout->addWidget(btnFlick);
    vbLayout2->addLayout(hbLayout);

    vbLayout->addWidget(frame);
    vbLayout->addStretch();
    setLayout(vbLayout);
}

StartWidget::~StartWidget()
{

}

void StartWidget::setContinueReading(){
    emit continueReading();
}

void StartWidget::setModeRapid(){
    emit exercise(Exercise::Rapid);
}

void StartWidget::setModeClassic(){
    emit exercise(Exercise::Classic);
}

void StartWidget::setExerciseShulte(){
    emit exercise(Exercise::Shulte);
}

void StartWidget::setExerciseNumbers(){
    emit exercise(Exercise::Numbers);
}

void StartWidget::setExerciseFlick(){
    emit exercise(Exercise::Flick);
}
