#ifndef ExerciseShulte_H
#define ExerciseShulte_H

#include "exercise.h"
#include "shultetable.h"

#include <QLabel>

class ExerciseShulte : public Exercise
{
Q_OBJECT
public:
    ExerciseShulte(QWidget *parent = 0);
    QWidget* settingsWidget();
    bool advancedMode();
    void showExerciseInfo();
    bool isActive();
    int mode();
protected:
    void mousePressEvent(QMouseEvent *);
    void resizeEvent(QResizeEvent *);

public slots:
    void start();
    void stop();
    void pause();
    void zoomIn();
    void zoomOut();

private slots:
    void setRowsCount(int);

private:
    void generateSettings();

    QWidget m_settingsWidget;
    QLabel m_lblExerciseInfo;
    ShulteTable m_shulte;
    bool m_activeState;
};

#endif // ExerciseShulte_H
