#include "aboutbox.h"

#include <QLabel>
#include <QPushButton>
#include <QVBoxLayout>

AboutBox::AboutBox(QWidget *parent) :
    QWidget(parent)
{
    QVBoxLayout *vbLayout = new QVBoxLayout(this);
    QLabel *lbl = new QLabel("<h1>"+tr("G-Speed Reader")+"</h1><br>"+tr("0.2 alpha / GPL version"));
    lbl->setAlignment(Qt::AlignCenter);
    vbLayout->addWidget(lbl);
    vbLayout->addStretch();
    lbl = new QLabel(tr("Increase the speed of your reading."));
    lbl->setAlignment(Qt::AlignCenter);
    vbLayout->addWidget(lbl);
    lbl = new QLabel(tr("By Slava Chernikoff (devious.code@gmail.com)"));
    lbl->setAlignment(Qt::AlignCenter);
    vbLayout->addWidget(lbl);
    vbLayout->addStretch();
    QPushButton *btn = new QPushButton(tr("OK"));
    btn->setIcon(QIcon::fromTheme("window-close", QIcon(":/img/ok.png")));
    connect(btn,SIGNAL(clicked()),this,SLOT(emitHidden()));
    vbLayout->addWidget(btn);
}

void AboutBox::emitHidden(){
    hide();
    emit hidden();
}
