/*
 * This file is part of fuelpad, the fuel diary
 *
 * Copyright (c) 2007-2010 Julius Luukko <julle.luukko@quicknet.inet.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "uimisc.h"

/*******************************************************************
 *
 * Public functions
 *
 *******************************************************************/

void get_color_by_name(const gchar *colorname, gchar *buf)
{
    GdkColor color;
    GtkStyle *style = gtk_rc_get_style_by_paths (gtk_settings_get_default (),
          NULL, NULL, GTK_TYPE_LABEL);

    if (gtk_style_lookup_color (style, colorname, &color))
    {
        sprintf(buf, "#%02x%02x%02x",
            color.red / 256, color.green / 256, color.blue / 256);
    }
    else
    {
        buf[0] = '\0';
    }
}

const gchar *get_secondary_text_color()
{
    static gchar buf[40] = {0};

    if (G_UNLIKELY (buf[0] == '\0'))
        get_color_by_name ("SecondaryTextColor", buf);

    return buf;
}

const gchar *get_active_text_color()
{
    static gchar buf[40] = {0};

    if (G_UNLIKELY (buf[0] == '\0'))
        get_color_by_name ("ActiveTextColor", buf);

    return buf;
}

const gchar *get_default_text_color()
{
    static gchar buf[40] = {0};

    if (G_UNLIKELY (buf[0] == '\0'))
        get_color_by_name ("DefaultTextColor", buf);

    return buf;
}
