/* 
 * This file is part of fuelpad, the fuel diary
 *
 * Copyright (c) 2007-2010 Julius Luukko <julle.luukko@quicknet.inet.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef _UILOGVIEW_H_
#define _UILOGVIEW_H_

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>

#include "ui.h"

/*******************************************************************
 *
 * Private definitions
 *
 *******************************************************************/

enum
{
  LOG_COL_STARTTIME = 0,
  LOG_COL_ENDTIME,
  LOG_COL_STARTLAT,
  LOG_COL_STARTLON,
  LOG_COL_STARTPLACE,
  LOG_COL_ENDLAT,
  LOG_COL_ENDLON,
  LOG_COL_ENDPLACE,
  LOG_COL_DISTANCE,
  LOG_COL_EFFECTIVETIME,
  LOG_COL_EXPLANATION,
  LOG_COL_ICON,
  LOG_COL_COMBINED,
  LOG_COL_ID,
  LOG_COL_VISIBLE,
  LOG_NUM_COLS
};

/*******************************************************************
 *
 * Public functions
 *
 *******************************************************************/

void update_logview_row_data(GtkListStore  *store,
			     GtkTreeIter   *iter,
			     double distance,
			     char *starttime,
			     double startlat,
			     double startlon,
			     char *startplace,
			     char *endtime,
			     double endlat,
			     double endlon,
			     char *endplace,
			     char* effectivetime,
			     char *explanation,
			     sqlite_int64 id);
GtkWidget *create_logview_and_model (void);


#endif
