/* 
 * This file is part of fuelpad, the fuel diary
 *
 * Copyright (c) 2007-2011 Julius Luukko <julle.luukko@quicknet.inet.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef _UILOCATIONVIEW_H_
#define _UILOCATIONVIEW_H_

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>

#include "ui.h"

/*******************************************************************
 *
 * Private definitions
 *
 *******************************************************************/

enum
{
  LOCATION_COL_LATITUDE = 0,
  LOCATION_COL_LONGITUDE,
  LOCATION_COL_PLACE,
  LOCATION_COL_ALIAS,
  LOCATION_COL_ICON,
  LOCATION_COL_COMBINED,
  LOCATION_COL_ID,
  LOCATION_COL_VISIBLE,
  LOCATION_NUM_COLS
};

/*******************************************************************
 *
 * Public functions
 *
 *******************************************************************/

void update_locationsview_row_data(GtkListStore  *store,
				   GtkTreeIter   *iter,
				   char *place,
				   char *alias,
				   double latitude,
				   double longitude,
				   sqlite_int64 id);
GtkWidget *create_locationview_and_model (void);


#endif
